from airflow import DAG
from airflow.providers.sftp.sensors.sftp import SFTPSensor
from airflow.providers.sftp.operators.sftp import SFTPOperator

with DAG(dag_id="sftp_example", start_date=None, schedule=None, tags=["r9", "with"]):

    t_wait_for_file = SFTPSensor(
        task_id="wait_for_file",
        path="upload/demo.txt",
        sftp_conn_id="example_sftp",
        poke_interval=15,
        timeout=120
    )
    
    t_get_file = SFTPOperator(
        task_id="get_file",
        ssh_conn_id="example_sftp",
        local_filepath="/airflow-sandbox/datasets/demo_copy.txt",
        remote_filepath="upload/demo.txt",
        operation="get"
    )

t_wait_for_file >> t_get_file