from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.providers.http.operators.http import HttpOperator

with DAG(dag_id="http_example", start_date=None, schedule=None,
         tags=["r4", "with"]):
    t_start = EmptyOperator(task_id="start")
    
    t_get_request = HttpOperator(
        task_id="get_requests",
        http_conn_id="http_json_placeholder",
        method="GET",
        endpoint="todos/1"
    )
    
t_start >> t_get_request