from airflow import DAG
from airflow.operators.python import PythonOperator
from airflow.providers.mongo.hooks.mongo import MongoHook

def connect_to_mongo():
    hook = MongoHook(mongo_conn_id="example_conn_mongo")
    client = hook.get_conn()
    print(f"Connected to MongoDB - {client.list_database_names()}")


with DAG(dag_id="mongo_example", schedule=None, start_date=None, tags= ["r9", "with"]):
    t_connect_mongo = PythonOperator(
        task_id="connect_mongo",
        python_callable=connect_to_mongo
        )

t_connect_mongo