from airflow import DAG
from airflow.providers.common.sql.operators.sql import BranchSQLOperator
from airflow.operators.empty import EmptyOperator

with DAG(dag_id="branch_sql", start_date=None, schedule=None, tags=["r6", "with"]):   
    logical_date = "{{ ds }}"
    
    t_branch_task = BranchSQLOperator(
        task_id='check_data_quality',
        conn_id='example_db_postgres',
        sql=f"SELECT count(*) FROM orders WHERE order_date = '{logical_date}'",
        follow_task_ids_if_true=['process_new_data'],
        follow_task_ids_if_false=['skip_processing']
    )

    t_process_new_data = EmptyOperator(task_id='process_new_data')
    t_skip_processing = EmptyOperator(task_id='skip_processing')

t_branch_task >> [t_process_new_data, t_skip_processing]

