from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.python import BranchPythonOperator, PythonOperator
from airflow.operators.bash import BashOperator


def choice_tasks():
    from random import randint
    value = randint(1,9)
    print(value)
    
    if 1 <= value <= 3:
        return "low_value"
    elif 4 <= value <= 6:
        return ["low_value", "high_value"]
    else:
        return "high_value"
    
def end_python_task():
    print("END")

with DAG(dag_id="trigger_rule", start_date=None, schedule=None,
         tags=["r4", "with"]):
    t_choice = BranchPythonOperator(
        task_id="choice_tasks",
        python_callable=choice_tasks
    )
    
    t_low = EmptyOperator(task_id="low_value")
    t_high = EmptyOperator(task_id="high_value")
    t_end = PythonOperator(task_id="end", python_callable=end_python_task,
                           trigger_rule="none_failed_min_one_success")
    
    t_always_failed = BashOperator(
        task_id="always_failed",
        bash_command="ls -l /tymczasowe"
    )
    
    t_always_run = BashOperator(
        task_id="always_run",
        bash_command="echo 'Airflow!'",
        trigger_rule="all_failed"
    )
    
t_choice >> [t_low, t_high] >> t_end
t_always_failed >> t_always_run