from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.bash import BashOperator
from airflow.sensors.filesystem import FileSensor
from datetime import timedelta

with DAG(dag_id="file_sensor", start_date=None, schedule=None,
         tags=["r4", "with"]):
    
    file_path = "/data/info.txt"
    
    t_start = EmptyOperator(task_id="start")
    
    check_file = FileSensor(
        task_id="check_file",
        mode="reschedule",
        poke_interval=timedelta(seconds=30),
        timeout=timedelta(minutes=5),
        fs_conn_id="fs_default",
        filepath=file_path
    )
    
    line_counter = BashOperator(
        task_id="line_counter",
        bash_command=f"wc -l {file_path}"
    )
    
t_start >> check_file >> line_counter

