from airflow import DAG
from airflow.operators.python import PythonOperator
from airflow.operators.empty import EmptyOperator
from datetime import datetime

def future_msg():
    print("I am from future!")
    

with DAG(dag_id="catchup_switch", 
         start_date=datetime(2025, 1, 1), 
         end_date=datetime(2026, 12, 31),
         catchup=False,
         schedule="@daily",
         tags=["r3", "with"]):
    t_future = PythonOperator(
        task_id="future_python",
        python_callable=future_msg,
        end_date=datetime(2025, 1, 31)
    )
    
    t_default = EmptyOperator(
        task_id="default"
    )
    
t_default
t_future

