from airflow import DAG
from airflow.operators.python import PythonOperator

def grettings():
    print("Hello Airflow from Python!")
    
def say_hi(name: str):
    print(f"Hello, {name}!")

with DAG(dag_id="python_operator", start_date=None, schedule=None,
         tags=["r2", "with"]):
    t_grettings = PythonOperator(
        task_id="grettings",
        python_callable=grettings
    )
    
    t_helion = PythonOperator(
        task_id="helion",
        python_callable=say_hi,
        op_args=["Helion"]
    )
    
    t_world = PythonOperator(
        task_id="world",
        python_callable=say_hi,
        op_kwargs={"name": "World"}
    )
    
t_grettings >> t_helion >> t_world