from airflow import DAG
from airflow.operators.bash import BashOperator
from airflow.providers.docker.operators.docker import DockerOperator
from datetime import datetime


with DAG(dag_id="docker_example", start_date=datetime(2025, 1, 1),
         schedule=None, tags=["r9", "with"]):  
    t_hello_docker = DockerOperator(
        task_id="hello_docker",
        image="debian:12",
        container_name="debian_container",
        command="echo 'Hello from container!'",
        auto_remove="force",
        docker_url="tcp://docker:2375",
        tty=False
)
    
t_hello_docker