from airflow import DAG
import pytz
from airflow.operators.python import PythonOperator
from airflow.operators.bash import BashOperator
from airflow.operators.trigger_dagrun import TriggerDagRunOperator
from datetime import datetime

def echo_logical_date(ld):
    print(ld)
    
with DAG(dag_id="child_dag_python", start_date=None, schedule=None,
         tags=["r7", "with"]):
    t_python_echo = PythonOperator(
        task_id="python_echo",
        python_callable=echo_logical_date,
        op_args=["{{ ds }}"]
    )
    
with DAG(dag_id="child_dag_bash", start_date=None, schedule=None,
         tags=["r7", "with"]):
    t_bash_echo = BashOperator(
        task_id="bash_echo",
        bash_command="echo {{ params.info }} && sleep 120"
    )


with DAG(dag_id="trigger_other_dag", start_date=None, schedule=None,
         tags=["r7", "with"]):
    t_trigger_python = TriggerDagRunOperator(
        task_id="trigger_python",
        trigger_dag_id="child_dag_python",
        execution_date=datetime(2010, 1, 1, tzinfo=pytz.timezone('America/New_York'))
    )
    
    t_trigger_bash = TriggerDagRunOperator(
        task_id="trigger_bash",
        trigger_dag_id="child_dag_bash",
        conf={"info": "Hello from Trigger!"},
        wait_for_completion=True,
        poke_interval=15
    )
    
t_trigger_python
t_trigger_bash