from airflow.decorators import dag, task
from airflow.providers.postgres.hooks.postgres import PostgresHook

@dag(dag_id="postgres_hook_tf", start_date=None, schedule=None,
     tags=["r7", "taskflow"])
def postgres_hook_tf():
    @task
    def export_data_to_csv(tbl_name):
        hook = PostgresHook(postgres_conn_id="example_db_postgres")
        hook.bulk_dump(tbl_name, f"/tmp/{tbl_name}.csv")
        
    t_export_data = export_data_to_csv("orders")
    t_export_data

postgres_hook_tf()