from airflow import DAG
from airflow.providers.common.sql.sensors.sql import SqlSensor

with DAG(dag_id="sql_sensor", start_date=None, schedule=None, tags=["r6", "with"]):
    t_wait_for_enough_data = SqlSensor(
        task_id='wait_for_enough_data',
        conn_id='example_db_postgres',
        sql='SELECT COUNT(*) FROM orders;',
        success=lambda row: row > 5,
        mode="poke",
        poke_interval=15,
        timeout=300
    )
        
    t_invalid_rows = SqlSensor(
        task_id='invalid_rows',
        conn_id='example_db_postgres',
        sql="SELECT COUNT(*) FROM customers WHERE status = 'pending'",
        failure=lambda row: row <= 3,
        mode="poke",
        poke_interval=15,
        timeout=300  
    )
    
t_wait_for_enough_data
t_invalid_rows