from airflow import DAG
from airflow.providers.common.sql.operators.sql import (
    SQLIntervalCheckOperator, SQLThresholdCheckOperator
)
    
with DAG(dag_id="interval_and_threshold", start_date=None, schedule=None, tags=["r6", "with"]):   
    t_interval_check = SQLIntervalCheckOperator(
    task_id='check_metrics_trends',
    conn_id='example_db_postgres',
    table='orders ',
    metrics_thresholds={
        'COUNT(*)': 1.5
    },
    date_filter_column='order_date',
    days_back=5,
    ratio_formula='max_over_min'
    )
    
    logical_date = '{{ds}}'
    
    t_threshold_check = SQLThresholdCheckOperator(
    task_id='check_order_count',
    conn_id='example_db_postgres',
    sql=f"SELECT MAX(min_stock_level) FROM inventory WHERE last_restock_date = '{logical_date}'",
    min_threshold=10,  
    max_threshold=20  
)
    
t_interval_check >> t_threshold_check