from airflow.decorators import dag, task
from datetime import datetime, timedelta

my_args = {
    "owner": "piotr",
    "start_date": datetime(2025, 2, 1),
    "email": ["admin@example.com"],
    "email_on_failure": False,
    "email_on_retry": False,
    "retries": 2,
    "retry_delay": timedelta(seconds=30),
    "retry_expontenial_backoff": False
}

@dag(dag_id="default_args_tf", start_date=None, schedule=None,
     default_args=my_args, tags=["r3", "taskflow"])
def default_args_tf():
    @task
    def t_start():
        pass
    
    @task.bash
    def t_echo():
        return "echo 'Hello, Airflow!'"
    
    t_echo = t_echo()
    t_start = t_start()
    t_start.set_downstream(t_echo)
    
default_args_tf()