from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.python import PythonOperator

dag_documentation = """
    # ID: dag_documentation_example
    To jest dokumentacja DAG-a
"""

task_yaml_doc = """
nazwa_zmiennej: t_python
parametry: |
    - funkcja: say_hi
    - id: python_task
"""

task_json_doc = """
{
    "argumenty": {
        "name": "Imię"
    }
}
"""

task_rst_doc = """
.. wersja:: 1.0
"""

def say_hi(name: str) -> None:
    print(f"Hello, {name}!")

with DAG(dag_id="dag_documentation_example", start_date=None, schedule=None,
         tags=["r3", "with"], doc_md=dag_documentation):
    t_start = EmptyOperator(task_id="start")
    
    t_python = PythonOperator(task_id="python_task",
                              python_callable=say_hi,
                              op_args=["Helion"],
                              doc_json=task_json_doc,
                              doc_yaml=task_yaml_doc,
                              doc_rst=task_rst_doc)

t_start >> t_python