from airflow import DAG
from airflow.operators.python import PythonOperator
import sys
from r2.my_module import random_number

def print_result(number):
    sys.path.append("/airflow-sandbox/crafting")
    from tools import is_even
    print(is_even(number))

with DAG(dag_id="python_imports", start_date=None, schedule=None,
         tags=["r2", "witg"]):
    t_random = PythonOperator(
        task_id="random_number",
        python_callable=random_number
    )
    
    t_custom_path = PythonOperator(
        task_id="custom_path",
        python_callable=print_result,
        op_kwargs={"number": 10}
    )