from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.bash import BashOperator

with DAG(dag_id="bash_example", start_date=None, schedule=None,
         tags=["r2", "with"],
         template_searchpath=["/airflow-sandbox/external-scripts/"]):
    t_start = EmptyOperator(task_id="start")
    t_echo = BashOperator(task_id="echo",
                          bash_command="echo 'Hello, Airflow!'")
    t_script = BashOperator(task_id="execute_script",
                            bash_command="scripts/check_hosts.sh")
    t_script_path = BashOperator(task_id="execute_script_path",
                            bash_command="show_date.sh")
    
t_start
t_echo
t_script
t_script_path