CREATE TABLE customers (
    customer_id INT PRIMARY KEY,
    first_name VARCHAR(50),
    last_name VARCHAR(50),
    email VARCHAR(100),
    registration_date DATE,
    status VARCHAR(20),
    loyalty_points INT DEFAULT 0,
    last_purchase_date DATE
);

INSERT INTO customers VALUES
(1, 'Jan', 'Kowalski', 'jan.kowalski@example.com', '2023-01-15', 'active', 150, '2024-03-20'),
(2, 'Anna', 'Nowak', 'anna.nowak@example.com', '2023-02-10', 'active', 320, '2024-04-05'),
(3, 'Piotr', 'Wiśniewski', 'piotr.wisniewski@example.com', '2023-03-22', 'inactive', 75, '2023-11-30'),
(4, 'Katarzyna', 'Dąbrowska', 'katarzyna.dabrowska@example.com', '2023-04-18', 'active', 410, '2024-04-10'),
(5, 'Michał', 'Lewandowski', 'michal.lewandowski@example.com', '2023-06-05', 'pending', 0, NULL),
(6, 'Agnieszka', 'Wójcik', 'agnieszka.wojcik@example.com', '2023-07-12', 'active', 280, '2024-03-15'),
(7, 'Tomasz', 'Kamiński', 'tomasz.kaminski@example.com', '2023-09-08', 'inactive', 120, '2023-12-20'),
(8, 'Małgorzata', 'Zielińska', 'malgorzata.zielinska@example.com', '2023-10-30', 'active', 195, '2024-04-02');

CREATE TABLE orders (
    order_id INT PRIMARY KEY,
    customer_id INT,
    order_date DATE,
    total_amount DECIMAL(10, 2),
    payment_method VARCHAR(50),
    status VARCHAR(20),
    shipping_address VARCHAR(200),
    FOREIGN KEY (customer_id) REFERENCES customers(customer_id)
);

INSERT INTO orders VALUES
(101, 1, '2024-01-15', 299.99, 'credit_card', 'delivered', 'ul. Kwiatowa 5, Warszawa'),
(102, 2, '2024-01-20', 149.50, 'bank_transfer', 'delivered', 'ul. Słoneczna 12, Kraków'),
(103, 4, '2024-02-03', 89.99, 'paypal', 'delivered', 'ul. Morska 8, Gdańsk'),
(104, 6, '2024-02-10', 499.99, 'credit_card', 'shipped', 'ul. Leśna 3, Poznań'),
(105, 1, '2024-03-20', 129.50, 'bank_transfer', 'delivered', 'ul. Kwiatowa 5, Warszawa'),
(106, 2, '2024-04-05', 219.99, 'paypal', 'processing', 'ul. Słoneczna 12, Kraków'),
(107, 3, '2023-11-30', 79.99, 'credit_card', 'delivered', 'ul. Długa 15, Wrocław'),
(108, 4, '2024-04-10', 349.50, 'bank_transfer', 'processing', 'ul. Morska 8, Gdańsk'),
(109, 6, '2024-03-15', 159.99, 'credit_card', 'delivered', 'ul. Leśna 3, Poznań'),
(110, 7, '2023-12-20', 99.50, 'paypal', 'delivered', 'ul. Polna 22, Łódź'),
(111, 8, '2024-04-02', 189.99, 'credit_card', 'shipped', 'ul. Krótka 7, Szczecin');

CREATE TABLE inventory (
    product_id INT PRIMARY KEY,
    product_name VARCHAR(100),
    category VARCHAR(50),
    price DECIMAL(10, 2),
    stock_quantity INT,
    last_restock_date DATE,
    min_stock_level INT,
    supplier_id INT
);

INSERT INTO inventory VALUES
(201, 'Smartfon XYZ', 'Elektronika', 1299.99, 45, '2024-03-01', 20, 301),
(202, 'Laptop Pro', 'Elektronika', 3999.99, 12, '2024-02-15', 5, 302),
(203, 'Słuchawki Bezprzewodowe', 'Akcesoria', 299.99, 78, '2024-03-20', 15, 301),
(204, 'Smartwatch Sport', 'Elektronika', 899.50, 23, '2024-01-10', 10, 303),
(205, 'Klawiatura Mechaniczna', 'Akcesoria', 349.99, 8, '2024-02-28', 10, 304),
(206, 'Monitor 4K', 'Elektronika', 1599.99, 15, '2024-03-05', 8, 302),
(207, 'Mysz Bezprzewodowa', 'Akcesoria', 129.99, 5, '2024-01-20', 20, 304),
(208, 'Powerbank 20000mAh', 'Akcesoria', 199.50, 60, '2024-03-15', 30, 301),
(209, 'Tablet Pro', 'Elektronika', 1899.99, 18, '2024-02-10', 10, 303),
(210, 'Kamera Internetowa HD', 'Akcesoria', 249.99, 3, '2024-03-10', 15, 302);