from airflow.decorators import dag, task
import pytz
from datetime import datetime
from airflow.operators.trigger_dagrun import TriggerDagRunOperator

@task
def echo_logical_date(ld):
    print(ld)

@dag(dag_id="child_dag_python_tf", start_date=None, schedule=None, tags=["r7", "taskflow"])
def child_dag_python_tf():
    echo_logical_date("{{ ds }}")

@dag(dag_id="child_dag_bash_tf", start_date=None, schedule=None, tags=["r7", "taskflow"])
def child_dag_bash_tf():
    @task.bash
    def echo_bash():
        return f"echo {{ params.info }} && sleep 120"

@dag(dag_id="trigger_other_dag_tf", start_date=None, schedule=None, tags=["r7", "taskflow"])
def trigger_other_dag_tf():
    t_trigger_python = TriggerDagRunOperator(
        task_id="trigger_python",
        trigger_dag_id="child_dag_python_tf",
        execution_date=datetime(2010, 1, 1, tzinfo=pytz.timezone('America/New_York'))
    )

    t_trigger_bash = TriggerDagRunOperator(
        task_id="trigger_bash",
        trigger_dag_id="child_dag_bash_tf",
        conf={"info": "Hello from Trigger!"},
        wait_for_completion=True,
        poke_interval=15
    )
    
    t_trigger_python
    t_trigger_bash  

child_dag_python_tf()
child_dag_bash_tf()
trigger_other_dag_tf()
