from airflow import DAG
from airflow.operators.bash import BashOperator
from airflow.operators.python import PythonOperator
from datetime import datetime

def wrong_use_jinja():
    print("{{ds}}")

with DAG(dag_id="jinja_template", 
         start_date=datetime(2025, 3, 1), 
         schedule="0 6 * * *",
         end_date=datetime(2025, 3, 8),
         tags=["r5", "with"]):
    
    t_echo_date = BashOperator(
        task_id="echo_date",
        bash_command="echo '{{logical_date.format('YYYY|MM|DD')}}'"
    )
    
    t_wrong = PythonOperator(
        task_id="wrong_use_jinja",
        python_callable=wrong_use_jinja
    )
    
    dag_run_id = "{{run_id}}"
    
    t_lambda_date = PythonOperator(
        task_id="lambda_date",
        python_callable=lambda x: print(x.upper()),
        op_args=[dag_run_id]
    )
    
t_echo_date >> [t_wrong, t_lambda_date]