from airflow import DAG
from airflow.operators.python import PythonVirtualenvOperator, PythonOperator


def show_example_person():
    from faker import Faker
    fake = Faker()
    print(fake.name())
    

with DAG(dag_id="python_venv", start_date=None, schedule=None,
         tags=["r2", "with"]):
    t_python = PythonOperator(
        task_id="python_example",
        python_callable=show_example_person
    )
    
    t_venv = PythonVirtualenvOperator(
        task_id="venv_example",
        python_callable=show_example_person,
        requirements=["Faker==37.0.2"]
    )
    
t_venv >> t_python