from airflow.decorators import dag, task

def day_number(number):
    match number:
        case 1:
            return "Poniedziałek"
        case 2:
            return "Wtorek"
        case 3:
            return "Środa"
        case 4:
            return "Czwartek"
        case 5:
            return "Piątek"
        case 6 | 7:
            return "Weekend"
        case _:
            return "Błędna wartość"

    

@dag(dag_id="python_external_tf", start_date=None, schedule=None,
     tags=["r2", "taskflow"])
def python_external_tf():
    @task
    def day_number(number):
        match number:
            case 1:
                return "Poniedziałek"
            case 2:
                return "Wtorek"
            case 3:
                return "Środa"
            case 4:
                return "Czwartek"
            case 5:
                return "Piątek"
            case 6 | 7:
                return "Weekend"
            case _:
                return "Błędna wartość"
            
    @task.external_python(python="/root/.pyenv/versions/3.9.21/bin/python")
    def day_number_external(number):
        match number:
            case 1:
                return "Poniedziałek"
            case 2:
                return "Wtorek"
            case 3:
                return "Środa"
            case 4:
                return "Czwartek"
            case 5:
                return "Piątek"
            case 6 | 7:
                return "Weekend"
            case _:
                return "Błędna wartość"
            
    t_python = day_number(1)
    t_external = day_number_external(3)
    
    t_python >> t_external

python_external_tf()

