from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.python import ShortCircuitOperator

def continue_condition():
    from random import randint
    return randint(0,10) % 2 == 0

with DAG(dag_id='short_circuit_example', start_date=None, schedule=None, tags=["r7", "with"]):
    t_start = EmptyOperator(task_id='start')
    
    t_short_circuit = ShortCircuitOperator(
        task_id='short_circuit',
        python_callable=continue_condition
    )
    t_task1 = EmptyOperator(task_id='my_next_task')
    t_task2 = EmptyOperator(task_id='my_another_task')

t_start >> t_short_circuit >> [t_task1, t_task2]