public class Turnstile
{
  internal static TurnstileState lockedState = new LockedTurnstileState();

  internal static TurnstileState unlockedState = new UnlockedTurnstileState();

  private TurnstileController turnstileController;
  internal TurnstileState state = unlockedState;

  public Turnstile(TurnstileController action)
  {
    turnstileController = action;
  }

  public void Coin()
  {
    state.Coin(this);
  }

  public void Pass()
  {
    state.Pass(this);
  }

  public void SetLocked()
  {
    state = lockedState;
  }

  public void SetUnlocked()
  {
    state = unlockedState;
  }

  public bool IsLocked()
  {
    return state == lockedState;
  }

  public bool IsUnlocked()
  {
    return state == unlockedState;
  }

  internal void Thankyou()
  {
    turnstileController.Thankyou();
  }

  internal void Alarm()
  {
    turnstileController.Alarm();
  }

  internal void Lock()
  {
    turnstileController.Lock();
  }

  internal void Unlock()
  {
    turnstileController.Unlock();
  }
}
