[TestFixture]
public class ProxyTest
{
  [SetUp]
  public void SetUp()
  {
    Db.Init();
    ProductData pd = new ProductData();
    pd.Sku = "ProxyTest1";
    pd.Name = "ProxyTestName1";
    pd.Price = 456;
    Db.Store(pd);
  }

  [TearDown]
  public void TearDown()
  {
    Db.DeleteProductData("ProxyTest1");
    Db.Close();
  }

  [Test]
  public void ProductProxy()
  {
    Product p = new ProductProxy("ProxyTest1");
    Assert.AreEqual(456, p.Price);
    Assert.AreEqual("ProxyTestName1", p.Name);
    Assert.AreEqual("ProxyTest1", p.Sku);
  }
}
