using System;
using System.Windows.Forms;

/// <summary>
/// QuickEntryMediator. Klasa otrzymuje na wejciu obiekt klasy TextBox
/// i obiekt klasy ListBox. Klasa QuickEntryMediator zakada, e uytkownik
/// bdzie wpisywa w polu tekstowym znaki bdce przedrostkami elementw
/// listy (kontrolki typu ListBox). Klasa QuickEntryMediator automatycznie
/// zaznacza pierwszy element tej listy, ktry pasuje do biecego przedrostka
/// w polu tekstowym.
///
/// Jeli pole tekstowe jest puste lub jeli podany tekst nie pasuje do
/// adnego z elementw kontrolki ListBox, klasa QuickEntryMediator usuwa
/// biece zaznaczenie z listy.
///
/// Dla obiektu tej klasy nie mona wywoywa adnych metod. Jego
/// stosowanie sprowadza si do skonstruowania. (Nie wolno jednak
/// dopuci, by pad ofiar mechanizmu odzyskiwania pamici...)
///
/// Przykad:
///
/// TextBox t = new TextBox();
/// ListBox l = new ListBox();
///
/// QuickEntryMediator qem = new QuickEntryMediator(t,l);
///  // To wszystko.
///
/// Oryginalna wersja tego kodu zostaa napisana 
/// w Javie przez Roberta C. Martina i Roberta S. Kossa
/// 30 czerwca 1999 roku.
/// Autorem tumaczenia na kod jzyka C# jest Micah Martin
/// (dokona tego 23 Maja maja 2005 roku w pocigu).
/// </summary>
public class QuickEntryMediator
{
  private TextBox itsTextBox;
  private ListBox itsList;

  public QuickEntryMediator(TextBox t, ListBox l)
  {
    itsTextBox = t;
    itsList = l;
    itsTextBox.TextChanged += new EventHandler(TextFieldChanged);
  }
  private void TextFieldChanged(object source, EventArgs args)
  {
    string prefix = itsTextBox.Text;

    if (prefix.Length == 0)
    {
      itsList.ClearSelected();
      return;
    }

    ListBox.ObjectCollection listItems = itsList.Items;
    bool found = false;
    for (int i = 0; found == false &&
              i < listItems.Count; i++)
    {
      Object o = listItems[i];
      String s = o.ToString();
      if (s.StartsWith(prefix))
      {
        itsList.SetSelected(i, true);
        found = true;
      }
    }
    if (!found)
    {
      itsList.ClearSelected();
    }
  }
}
