using System;

namespace Payroll
{
  public class ServiceChargeTransaction : Transaction
  {
    private readonly int memberId;
    private readonly DateTime time;
    private readonly double charge;

    public ServiceChargeTransaction(int id, DateTime time, double charge)
    {
      this.memberId = id;
      this.time = time;
      this.charge = charge;
    }

    public void Execute()
    {
      Employee e = PayrollDatabase.GetUnionMember(memberId);

      if (e != null)
      {
        UnionAffiliation ua = null;
        if(e.Affiliation is UnionAffiliation)
          ua = e.Affiliation as UnionAffiliation;

        if (ua != null)
          ua.AddServiceCharge(new ServiceCharge(time, charge));
        else
          throw new InvalidOperationException(
            "Prba obcienia skadk zwizkow pracownika, "
            + "ktry nie naley do zwizku zawodowego.");
        }
      else
        throw new InvalidOperationException(
          "Nie ma takiego czonka zwizku.")  ;
    }
  }
}
