using System;
using System.Reflection;
using NUnit.Framework;

[TestFixture]
public class TestSimpleSingleton
{
  [Test]
  public void TestCreateSingleton()
  {
    Singleton s = Singleton.Instance;
    Singleton s2 = Singleton.Instance;
    Assert.AreSame(s, s2);
  }

  [Test]
  public void TestNoPublicConstructors()
  {
    Type singleton = typeof(Singleton);
    ConstructorInfo[] ctrs = singleton.GetConstructors();
    bool hasPublicConstructor = false;
    foreach(ConstructorInfo c in ctrs)
    {
      if(c.IsPublic)
      {
        hasPublicConstructor = true;
        break;
      }
    }
    Assert.IsFalse(hasPublicConstructor);
  }
}
