///<remark>
/// Klasa PrimeGenerator generuje liczby pierwsze od 1 do wartoci
/// maksymalnej okrelonej przez uytkownika. Ponisza klasa
/// wykorzystuje klasyczny algorytm sita Eratostenesa. Pocztkowo dysponujemy
/// tablic kolejnych liczb cakowitych (poczwszy od 2). Odnajdujemy pierwsz
/// zakwalifikowan liczb cakowit, po czym odrzucamy wszystkie jej wielokrotnoci.
/// Powtarzamy t procedur a do osignicia wartoci rwnej pierwiastkowi
/// kwadratowemu liczby maksymalnej.
///</remark>
using System;
public class PrimeGenerator
{
  private static bool[] crossedOut;
  private static int[] result;

  public static int[] GeneratePrimeNumbers(int maxValue)
  {
    if (maxValue < 2)
      return new int[0];
    else
    {
      UncrossIntegersUpTo(maxValue);
      CrossOutMultiples();
      PutUncrossedIntegersIntoResult();
      return result;
    }
  }

  private static void UncrossIntegersUpTo(int maxValue)
  {
    crossedOut = new bool[maxValue + 1];
    for (int i = 2; i < crossedOut.Length; i++)
      crossedOut[i] = false;
  }

  private static void PutUncrossedIntegersIntoResult()
  {
    result = new int[NumberOfUncrossedIntegers()];
    for (int j = 0, i = 2; i < crossedOut.Length; i++)
    {
      if (NotCrossed(i))
        result[j++] = i;
    }
  }

  private static int NumberOfUncrossedIntegers()
  {
    int count = 0;
    for (int i = 2; i < crossedOut.Length; i++)
    {
      if (NotCrossed(i))
        count++; // zwikszajcy si licznik
    }
    return count;
  }

  private static void CrossOutMultiples()
  {
    int limit = DetermineIterationLimit();
    for (int i = 2; i <= limit; i++)
    {
      if(NotCrossed(i))
        CrossOutputMultiplesOf(i);
    }
  }
  private static int DetermineIterationLimit()
  {
    // Dla kadej wielokrotnoci skadowanej w tej tablicy istnieje czynnik pierwszy,
    // ktry jest mniejszy lub rwny pierwiastkowi kwadratowemu z rozmiaru tej tablicy,
    // zatem nie musimy eliminowa wielokrotnoci liczb, ktre s wiksze od tego
    // pierwiastka.
    double iterationLimit = Math.Sqrt(crossedOut.Length);
    return (int) iterationLimit;
  }

  private static void CrossOutputMultiplesOf(int i)
  {
    for (int multiple = 2*i;
       multiple < crossedOut.Length;
       multiple += i)
      crossedOut[multiple] = true;
  }

  private static bool NotCrossed(int i)
  {
    return crossedOut[i] == false;
  }
}
