[TestFixture]
public class BOMReportTest
{
  private PiecePart p1;
  private PiecePart p2;
  private Assembly a;

  [SetUp]
  public void SetUp()
  {
    p1 = new PiecePart("997624", "Moja cz", 3.20);
    p2 = new PiecePart("7734", "Pieko", 666);
    a = new Assembly("5879", "Mj element");
  }

  [Test]
  public void CreatePart()
  {
    Assert.AreEqual("997624", p1.PartNumber);
    Assert.AreEqual("Moja cz", p1.Description);
    Assert.AreEqual(3.20, p1.Cost, .01);
  }

  [Test]
  public void CreateAssembly()
  {
    Assert.AreEqual("5879", a.PartNumber);
    Assert.AreEqual("Mj element", a.Description);
  }

  [Test]
  public void Assembly()
  {
    a.Add(p1);
    a.Add(p2);
    Assert.AreEqual(2, a.Parts.Count);
    PiecePart p = a.Parts[0] as PiecePart;
    Assert.AreEqual(p, p1);
    p = a.Parts[1] as PiecePart;
    Assert.AreEqual(p, p2);
  }

  [Test]
  public void AssemblyOfAssemblies()
  {
    Assembly subAssembly = new Assembly("1324", "Podelement");
    subAssembly.Add(p1);
    a.Add(subAssembly);

    Assert.AreEqual(subAssembly, a.Parts[0]);
  }

  private class TestingVisitor : PartVisitor
  {
    public IList visitedParts = new ArrayList();

    public void Visit(PiecePart p)
    {
      visitedParts.Add(p);
    }

    public void Visit(Assembly assy)
    {
      visitedParts.Add(assy);
    }
  }

  [Test]
  public void VisitorCoverage()
  {
    a.Add(p1);
    a.Add(p2);

    TestingVisitor visitor = new TestingVisitor();
    a.Accept(visitor);

    Assert.IsTrue(visitor.visitedParts.Contains(p1));
    Assert.IsTrue(visitor.visitedParts.Contains(p2));
    Assert.IsTrue(visitor.visitedParts.Contains(a));
  }

  private Assembly cellphone;

  private void SetUpReportDatabase()
  {
    cellphone = new Assembly("CP-7734", "Telefon komrkowy");
    PiecePart display = new PiecePart("DS-1428", "Wywietlacz LCD", 14.37);
    PiecePart speaker = new PiecePart("SP-92", "Gonik", 3.50);
    PiecePart microphone = new PiecePart("MC-28", "Mikrofon", 5.30);
    PiecePart cellRadio = new PiecePart("CR-56", "Radio", 30);
    PiecePart frontCover = new PiecePart("FC-77", "Obudowa przednia", 1.4);
    PiecePart backCover = new PiecePart("RC-77", "Obudowa tylna", 1.2);
    Assembly keypad = new Assembly("KP-62", "Klawiatura");
    Assembly button = new Assembly("B52", "Klawisz");
    PiecePart buttonCover = new PiecePart("CV-15", "Obudowa", .5);
    PiecePart buttonContact = new PiecePart("CN-2", "Styk", 1.2);
    button.Add(buttonCover);
    button.Add(buttonContact);
    for (int i = 0; i < 15; i++)
      keypad.Add(button);
    cellphone.Add(display);
    cellphone.Add(speaker);
    cellphone.Add(microphone);
    cellphone.Add(cellRadio);
    cellphone.Add(frontCover);
    cellphone.Add(backCover);
    cellphone.Add(keypad);
  }

  [Test]
  public void ExplodedCost()
  {
    SetUpReportDatabase();
    ExplodedCostVisitor v = new ExplodedCostVisitor();
    cellphone.Accept(v);
    Assert.AreEqual(81.27, v.Cost, .001);
  }

  [Test]
  public void PartCount()
  {
    SetUpReportDatabase();
    PartCountVisitor v = new PartCountVisitor();
    cellphone.Accept(v);
    Assert.AreEqual(36, v.PieceCount);
    Assert.AreEqual(8, v.PartNumberCount);
    Assert.AreEqual(1, v.GetCountForPart("DS-1428"), "DS-1428");
    Assert.AreEqual(1, v.GetCountForPart("SP-92"), "SP-92");
    Assert.AreEqual(1, v.GetCountForPart("MC-28"), "MC-28");
    Assert.AreEqual(1, v.GetCountForPart("CR-56"), "CR-56");
    Assert.AreEqual(1, v.GetCountForPart("RC-77"), "RC-77");
    Assert.AreEqual(15, v.GetCountForPart("CV-15"), "CV-15");
    Assert.AreEqual(15, v.GetCountForPart("CN-2"), "CN-2");
    Assert.AreEqual(0, v.GetCountForPart("Bartosz"), "Bartosz");
  }
}
