﻿package
{
  import flash.display.*;
  import flash.geom.ColorTransform;
  import flash.events.MouseEvent;
  import flash.events.DataEvent;
  public class ColorPicker extends Sprite
  {
    private var k:int = 255;
    public function ColorPicker()
    {
      for(var i:int = 0;i < 256; i += 48)
      {
        for(var j:int = 0;j < 256; j += 48)
        {
          var spr:Sprite = new Sprite();
          spr.graphics.beginFill(0xFFFFFF, 1);
          spr.graphics.drawRect(0, 0, 20, 20);
          spr.graphics.endFill();
          // zastosuj transformację kolorów
          var trans:ColorTransform = new ColorTransform();
          var red:uint = i << 16;
          trans.color = red + green + blue;
          var green:uint = j << 8;
          var blue:uint = k;
          trace(red + " " + blue + " " + green + " " + trans.color);
          spr.transform.colorTransform = trans;
          addChild(spr);
          spr.addEventListener(MouseEvent.CLICK, dispatchColorPicked);
          spr.x = i / 2;
          spr.y = j / 2;
          k -= 48;
        }
      }
    }
    private function dispatchColorPicked(mouseEvent:MouseEvent):void
    {
      var target:Sprite = mouseEvent.target as Sprite;
      var trans:ColorTransform = target.transform.colorTransform;
      var color:uint = trans.color;
      var dataEvent:DataEvent = new DataEvent("colorSelected", false, false, trans.color.toString(16));
      dispatchEvent(dataEvent);
    } 
  }
}
