﻿package {
  import flash.display.*;
  import flash.media.*;
  import flash.net.*;
  import flash.text.*;
  import flash.events.*;

  public class SimpleSoundPlayer extends Sprite {
    private var _sound:Sound;
    private var _channel:SoundChannel;
    private var _pausePosition:Number;

    private var _rewButton:Sprite;
    private var _pauseButton:Sprite;
    private var _replayButton:Sprite;
    private var _ffButton:Sprite;
    private var _positionDisplay:TextField;

    private const SONG_URL:String = "song.mp3";
    private const SEARCH_RATE:int = 2000; // Rozmiar przewinięcia wprzód lub wstecz dla każdego kliknięcia
  
  public function SimpleSoundPlayer() {
      _sound = new Sound(new URLRequest(SONG_URL));
      play();

      _positionDisplay = new TextField();
      _positionDisplay.y = 50;
      addChild(_positionDisplay);

      _rewButton = new Sprite();
      _rewButton.graphics.beginFill(0x66CCFFFF);
      _rewButton.graphics.drawRect(0, 0, 20, 20);
      addChild(_rewButton);

      var rewLabel:TextField = new TextField();
      rewLabel.text = "<<";
      rewLabel.selectable = false;
      _rewButton.addChild(rewLabel);

      _pauseButton = new Sprite();
      _pauseButton.x = 30;
      _pauseButton.graphics.beginFill(0x66CCFFFF);
      _pauseButton.graphics.drawRect(0, 0, 20, 20);
      addChild(_pauseButton);

      var pauseLabel:TextField = new TextField();
      pauseLabel.text = "||";
      pauseLabel.selectable = false;
      _pauseButton.addChild(pauseLabel);

      _replayButton = new Sprite();
      _replayButton.x = 60;
      _replayButton.graphics.beginFill(0x66CCFFFF);
      _replayButton.graphics.drawRect(0, 0, 20, 20);
      addChild(_replayButton);

      var replayLabel:TextField = new TextField();
      replayLabel.text = ">";
      replayLabel.selectable = false;
      _replayButton.addChild(replayLabel);

      _ffButton = new Sprite();
      _ffButton.x = 90;
      _ffButton.graphics.beginFill(0x66CCFFFF);
      _ffButton.graphics.drawRect(0, 0, 20, 20);
      addChild(_ffButton);

      var ffLabel:TextField = new TextField();
      ffLabel.text = ">>";
      ffLabel.selectable = false;
      _ffButton.addChild(ffLabel);

      _rewButton.addEventListener(MouseEvent.CLICK, rewind);
      _pauseButton.addEventListener(MouseEvent.CLICK, pause);
      _replayButton.addEventListener(MouseEvent.CLICK, replay);
      _ffButton.addEventListener(MouseEvent.CLICK, fastForward);
      this.addEventListener(Event.ENTER_FRAME, updatePositionDisplay);
    }
    public function play(position:int = 0):void {
      if (_channel) {
        _channel.stop();
      }
      _channel = _sound.play(position);
    }

    public function rewind(event:Event = null):void {
      if (_channel) {
        var newPosition:int = _channel.position - SEARCH_RATE;
        newPosition = Math.max(0, newPosition);
        play(newPosition);
      }
    }

    public function fastForward(event:Event = null):void {
      if (_channel) {
        var newPosition:int = _channel.position + SEARCH_RATE;
        newPosition = Math.min(_sound.length, newPosition);
        play(newPosition);
      }
    }

    public function pause(event:MouseEvent):void {
      _pausePosition = _channel.position;
      _channel.stop();
    }

    public function replay(event:MouseEvent):void {
      play(_pausePosition);
    }

    /**
    * Uaktualnij tekst wyświetlający pozycję bieżącą pozycję 
    * względem całej długości utworu w sekundach.
    */
    public function updatePositionDisplay(event:Event = null):void {
      var currentPosition:Number = Math.round(_channel.position / 1000);
      var totalLength:Number = Math.round(_sound.length / 1000);
      _positionDisplay.text = currentPosition + " / " + totalLength;
    }
  }
}
