package {

	import flash.display.Sprite;
	import flash.events.Event;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;

	public class SoundExample extends Sprite {

		private var _channel:SoundChannel;
		private var _graph:Sprite;

		public function SoundExample() {
			Security.loadPolicyFile( "http://rightactionscript.com/crossdomain.xml");
			var sound:Sound = new Sound();
			sound.load(new URLRequest("http://rightactionscript.com/samplefiles/Demo.mp3"), new SoundLoaderContext(1000, true));
			_channel = sound.play();
			_graph = new Sprite();
			_graph.y = 200;
			addChild(_graph);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		private function enterFrameHandler(event:Event):void {
			var bytes:ByteArray = new ByteArray();
			SoundMixer.computeSpectrum(bytes);
			_graph.graphics.clear();
			_graph.graphics.lineStyle(0, 0, 1);
			var plotX:Number = 0;
			for(var i:Number = 0; i < 256; i++) {
				_graph.graphics.lineTo(plotX, bytes.readFloat() * stage.stageHeight / 2);
				plotX += stage.stageWidth / 256;
			}
		}
	}
}
