﻿package
{
  import flash.display.Sprite;
  import flash.events.MouseEvent;
  import flash.events.DataEvent;
  public class ToolSet extends Sprite
  {
    public var circle:Sprite;
    public var square:Sprite;
    public var line:Sprite;
    public var eraser:Sprite;
    public function ToolSet()
    {
      line = new Sprite();
      line.graphics.lineStyle(5, 0x000000);
      line.graphics.lineTo(30, 30);
      circle = new Sprite();
      circle.graphics.beginFill(0x000000, 1)
      circle.graphics.drawCircle(0, 0, 15);
      square = new Sprite();
      square.graphics.beginFill(0x000000, 1);
      square.graphics.drawRect(0, 0, 30, 30);
      eraser = new Sprite();
      eraser.graphics.lineStyle(5, 0x000000);
      eraser.graphics.lineTo(30, 30);
      eraser.graphics.moveTo(30, 0);
      eraser.graphics.lineTo(0, 30);
      addChild(square);
      addChild(circle);
      addChild(line);
      addChild(eraser);
      square.addEventListener(MouseEvent.MOUSE_DOWN, toolClicked);
      line.addEventListener(MouseEvent.MOUSE_DOWN, toolClicked);
      circle.addEventListener(MouseEvent.MOUSE_DOWN, toolClicked);
      eraser.addEventListener(MouseEvent.MOUSE_DOWN, toolClicked);
      circle.y = 15;
      square.x = 25;
      line.x = 60;
      eraser.x = 95;
    }
    private function toolClicked(mouseEvent:MouseEvent):void
    {
      var tool:String;
      switch(mouseEvent.target)
      {
        case square:
          tool = "square";
          break;
        case line:
          tool = "line";
          break;
        case circle:
          tool = "circle";
          break;
        case eraser:
          tool = "eraser";
          break;
      }
      dispatchEvent(new DataEvent("toolSelected", false, false, tool));
    }
  }
}
