﻿package
{
  import flash.display.Shape;
  import flash.display.Sprite;
  import flash.events.DataEvent;
  import flash.events.MouseEvent;
  import flash.geom.Point;
  public class DrawingCanvas extends Sprite
  {
    private var _stage:Sprite;
    private var toolState:String = "line";
    private var drawingShape:Shape;
    private var currentColor:uint;
    private var currentShape:Shape;
    private var lineThickness:Number = 4;
    private var colorPicker:ColorPicker;
    private var toolSet:ToolSet;
    private var startPoint:Point = new Point(0, 0);

    public function DrawingCanvas()
    {
      stage.scaleMode = "noScale";
      stage.align = "TL";
      _stage = new Sprite();
      _stage.graphics.beginFill(0xFFFFFF, 1);
      _stage.graphics.drawRect(0, 0, 500, 500);
      _stage.graphics.endFill();
      addChild(_stage);
      _stage.addEventListener(MouseEvent.MOUSE_DOWN, startDraw);
      _stage.addEventListener(MouseEvent.MOUSE_UP, stopDraw);
      colorPicker = new ColorPicker();
      addChild(colorPicker);
      colorPicker.x = 0;
      colorPicker.addEventListener("colorSelected", changeColor);
      toolSet = new ToolSet();
      addChild(toolSet);
      toolSet.y = 150;
      toolSet.x = 20;
      toolSet.addEventListener("toolSelected", changeTool);
      drawingShape = new Shape();
    }

    private function stopDraw(mouseEvent:MouseEvent):void
    {
      _stage.removeEventListener(MouseEvent.MOUSE_MOVE, draw);
    }

    private function startDraw(mouseEvent:MouseEvent):void
    {
      var newShape:Shape = new Shape();
      startPoint.x = _stage.mouseX;
      startPoint.y = _stage.mouseY;
      drawingShape = newShape;
      _stage.addEventListener(MouseEvent.MOUSE_MOVE, draw);
      if(toolState == "line" || toolState == "eraser")
      {
        drawingShape.graphics.moveTo(mouseEvent.stageX, mouseEvent.stageY);
      }
    }

    private function draw(mouseEvent:MouseEvent):void
    {
      switch(toolState)
      {
        case "line":
          drawingShape.graphics.lineStyle(lineThickness, currentColor);
          drawingShape.graphics.lineTo(mouseEvent.stageX, mouseEvent.stageY);
          addChild(drawingShape);
          break;
        case "circle":
          drawingShape.graphics.clear();
          drawingShape.graphics.beginFill(currentColor, 1);
          drawingShape.graphics.drawCircle(startPoint.x, startPoint.y,    findDistance(mouseEvent));
          addChild(drawingShape);
          break;
        case "square":
          drawingShape.graphics.clear();
          drawingShape.graphics.beginFill(currentColor, 1);
          drawingShape.graphics.drawRect(startPoint.x, startPoint.y, _stage.mouseX - startPoint.x, _stage.mouseY - startPoint.y);
          addChild(drawingShape);
          break;
        case "eraser":
          drawingShape.graphics.lineStyle(lineThickness, currentColor);
          drawingShape.graphics.lineTo(mouseEvent.stageX, mouseEvent.stageY);
          addChild(drawingShape);
          break;
      }
    }

    private function changeTool(evt:DataEvent):void
    {
      toolState = evt.data;
      if(toolState == "eraser")
      {
        currentColor = 0xFFFFFF;
      }
    }

    private function changeColor(dataEvent:DataEvent):void
    {
      currentColor = parseInt(dataEvent.data, 16);
      drawingShape.graphics.lineStyle(lineThickness, currentColor);
      if(toolState == "eraser")
      {
        toolState = "line";
      }
    }

    private function findDistance(mouseEvent:MouseEvent):Number
    {
      var dist:Number = Math.sqrt(Math.pow(_stage.mouseX - startPoint.x, 2) +
Math.pow(_stage.mouseY - startPoint.y, 2));
      return dist;
    }
  }
}
