﻿package  {
  import flash.display.Sprite;
  import flash.text.TextField;
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.events.IOErrorEvent;
  import flash.events.ProgressEvent;
  import flash.events.SecurityErrorEvent;
  import flash.net.FileReference;
  import flash.net.URLRequest;
  public class FileUpload extends Sprite {
    private var _browse:TextField;
    private var _upload:TextField;
    private var _output:TextField;
    private var _fileReference:FileReference;
    public function FileUpload() {
      _browse = new TextField();
      _browse.htmlText = "<u>Kliknij, aby przeglądać pliki</u>";
      _browse.addEventListener(MouseEvent.CLICK, browseHandler);
      addChild(_browse);
      _upload = new TextField();
      _upload.htmlText = "<u>Kliknij, aby wysłać plik</u>";
      _upload.addEventListener(MouseEvent.CLICK, uploadHandler);
      _upload.x = 200;
      _upload.visible = false;
      addChild(_upload);
      _output = new TextField();
      _output.width = 400;
      _output.height = 400;
      _output.y = 50;
      addChild(_output);
      _fileReference = new FileReference();
      _fileReference.addEventListener(Event.SELECT, selectHandler);
      _fileReference.addEventListener(Event.CANCEL, cancelHandler);
      _fileReference.addEventListener(ProgressEvent.PROGRESS, progressHandler);
      _fileReference.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
      _fileReference.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityHandler);
      _fileReference.addEventListener(Event.COMPLETE, completeHandler);
    }
    private function browseHandler(event:MouseEvent):void {
      _fileReference.browse();
    }
    private function selectHandler(event:Event):void {
      _output.text = "Wybrany plik";
      _output.appendText("\nNazwa: " + _fileReference.name);
      _output.appendText("\nRozmiar: " + _fileReference.size);
      _output.appendText("\nData utworzenia: " + _fileReference.creationDate);
      _output.appendText("\nData ostatniej modyfikacji: " + _fileReference.modificationDate);
      _upload.visible = true;
    }
    private function cancelHandler(event:Event):void {
      _output.text = "Anulowano";
    }
    private function uploadHandler(event:MouseEvent):void {
      _fileReference.upload(new URLRequest("simpleFileUpload.php"));
    }
    private function progressHandler(event:ProgressEvent):void {
      _output.text = "Wysyłanie pliku\brak postępu (bajtów): " + event.bytesLoaded + " / " + event.bytesTotal;
    }
    private function ioErrorHandler(event:IOErrorEvent):void {
      _output.text = "Wystąpił błęd wejścia/wyjścia";
    }
    private function securityHandler(event:SecurityErrorEvent):void {
      _output.text = "Wystąpił błąd bezpieczeństwa";
    }
    private function completeHandler(event:Event):void {
      _output.text = "Plik został wysłany";
    }
  }
}
