﻿package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	public class CollidingBalls extends Sprite {
		private var firstBall:Sprite;
		private var secondBall:Sprite;
		private var direction:int;
		private var firstX:int = 3;
		private var firstY:int = 2;
		private var secondX:int = -2;
		private var secondY:int = -3;
		public function CollidingBalls() {
			super();
			firstBall = new Sprite();
			secondBall = new Sprite();
			firstBall.graphics.beginFill(0x00FF00, 1.0);
			firstBall.graphics.drawCircle(0, 0, 20);
			firstBall.graphics.endFill();
			secondBall.graphics.beginFill(0x0000FF, 1.0);
			secondBall.graphics.drawCircle(0, 0, 20);
			secondBall.graphics.endFill();
			addChild(firstBall);
			addChild(secondBall);
			firstBall.x = 10;
			firstBall.y = 10;
			secondBall.x = 190;
			secondBall.y = 190;
			firstBall.addEventListener(Event.ENTER_FRAME, collide);
			secondBall.addEventListener(Event.ENTER_FRAME, collide);
			addEventListener(Event.ENTER_FRAME, moveSprites);
		}
		private function collide(event:Event):void {
			if (firstBall.hitTestObject(secondBall)) {
				trace("pierwsza uderzyła w drugą ");
			}
			if (secondBall.hitTestObject(firstBall)) {
				trace("druga uderzyła w pierwszą ");
			}
		}
		private function moveSprites(evt:Event):void {
			if (!inXBounds(firstBall)) {
				firstX *= -1;
			}
			if (!inYBounds(firstBall)) {
				firstY *= -1;
			}
			firstBall.x += firstX;
			firstBall.y += firstY;
			if (!inXBounds(secondBall)) {
				secondX *= -1;
			}
			if (!inYBounds(secondBall)) {
				secondY *= -1;
			}
			secondBall.x += secondX;
			secondBall.y += secondY;
		}
		private function inXBounds(spr:Sprite):Boolean {
			var glPoint:Point = localToGlobal(new Point(spr.x, spr.y));
			if (glPoint.x < 200 && glPoint.x > 1) {
				return true;
			}
			return false;
		}
		private function inYBounds(spr:Sprite):Boolean {
			var glPoint:Point = localToGlobal(new Point(spr.x, spr.y));
			if (glPoint.y < 200 && glPoint.y > 1) {
				return true;
			}
			return false;
		}
	}
}