﻿package
{
import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.media.Video;
import flash.net.NetConnection;
import flash.net.NetStream;
import flash.text.TextField;
import flash.utils.Timer;
public class SimpleVideo extends Sprite
{
    private var nDuration:Number = 0;
    private var nsVideo:NetStream;
    private var vFLV:Video;
    private var ncVideo:NetConnection;
    private var playBtn:VideoButton;
    private var stopBtn:VideoButton;
    private var timeline:Timeline;
    private var timer:Timer;
    private var isPlaying:Boolean = true;
    private var isDragging:Boolean = false;
    private var currentTimeTxt:TextField;

    public function SimpleVideo()
    {
        stage.scaleMode = "noScale";
        var ncVideo:NetConnection = new NetConnection();
        ncVideo.connect(null);
        nsVideo = new NetStream(ncVideo);
        nsVideo.play("video.flv");
        currentTimeTxt = new TextField();
        addChild(currentTimeTxt);
        currentTimeTxt.y = 360;
        currentTimeTxt.height = 20;
        vFLV = new Video();
        addChild(vFLV);
        vFLV.attachNetStream(nsVideo);
        var clientObject:Object = new Object();
        clientObject.onMetaData = onMetaData;
        nsVideo.client = clientObject;
        playBtn = new VideoButton("play");
        stopBtn = new VideoButton("stop");
        addChild(playBtn);
        addChild(stopBtn);
        stopBtn.x = 200;

        playBtn.addEventListener(VideoButton.CLICKED, play);
        stopBtn.addEventListener(VideoButton.CLICKED, stop);

        timer = new Timer(100);
        timer.addEventListener(TimerEvent.TIMER, updateProgress);
        timeline = new Timeline();
        timeline.addEventListener(Timeline.SEEKING, beginSeek);
        timeline.addEventListener(Timeline.FINISHED_SEEKING, finishedSeek);
        addChild(timeline);
        timeline.y = 420;
    }

    private function beginSeek(event:Event):void
    {
        nsVideo.pause();
        isPlaying = false;
        isDragging = true;
    }

    private function finishedSeek(event:Event):void
    {
        nsVideo.resume();
        nsVideo.seek(nDuration * ((timeline.playhead.x + 10) / 100));
        isDragging = false;
        isPlaying = true;
    }

    private function onMetaData(oMetaData:Object):void
    {
        nDuration = oMetaData.duration;
        timeline.updatePlayhead(nDuration);
        timer.start();
    }

    private function play(event:Event):void
    {
        if (isPlaying)
        {
            isPlaying = false;
            nsVideo.pause();
        } else {
            isPlaying = true;
            nsVideo.resume();
        }
    }

    private function stop(event:Event):void
    {
        nsVideo.pause();
        nsVideo.seek(0);
    }

    private function updateProgress(timerEvent:TimerEvent):void
    {
        var nPercent:Number = 100 * nsVideo.time / nDuration;
        currentTimeTxt.text = nsVideo.time.toString();
        if (!isDragging)
        {
        	timeline.updatePlayhead(nPercent);
        }
    }
}
}

