﻿package pl.helion.as3biblia.kitchen 
{
	import flash.display.Sprite;
	
	public class HeatedResistorToaster extends Toaster
	{
		private var remainingToastSec:Number;
		private var insertedBread:Bread;
		private var resistor:Resistor;
		
		public function HeatedResistorToaster()
		{
			resistor = new Resistor();
			remainingToastSec = 0;
		}
		
		public function toast(pieceOfBread:Bread):Bread
		{
			insertedBread = pieceOfBread;
			startTimer(10);
			startCurrent(0.5);
			while (remainingToastSec > 0)
			{
				tick();
				remainingToastSec --;
			}
			stopTimer();
			stopCurrent();
			insertedBread = null;
			return pieceOfBread;
		}
		
		private function startTimer(toastDuration:Number):void 
		{
			remainingToastSec = toastDuration;
		}
		
		private function startCurrent(currentAmps:Number):void
		{
			resistor.current = currentAmps;
		}
		
		private function tick():void
		{
			resistor.tick();
			insertedBread.toastiness += resistor.heat * 0.55667;
		}
		
		private function stopTimer():void
		{
			trace("Toster daje sygnał dzwonkiem!");
		}
		
		private function stopCurrent():void
		{
			resistor.current = 0;
		}
	}
}
