﻿package
{
  import flash.display.Sprite;
  import flash.text.TextField;
  import flash.events.MouseEvent;
  import flash.text.TextFormat;
  import flash.display.StageAlign;
  import flash.display.StageScaleMode;
  public class MultilineTextExample extends Sprite
  {
    private var multilineField:TextField;
    private var redFormat:TextFormat;
    private var blackFormat:TextFormat;
    public function MultilineTextExample()
    {
      stage.align = StageAlign.TOP_LEFT;
      stage.scaleMode = StageScaleMode.NO_SCALE;
      redFormat = new TextFormat();
      redFormat.color = 0xFF0000;
      blackFormat = new TextFormat();
      blackFormat.color = 0x000000;
      multilineField = new TextField();
      multilineField.multiline = true;
      multilineField.wordWrap = true;
      multilineField.height = 400;
      multilineField.width = 400;
      multilineField.mouseEnabled = true;
      multilineField.addEventListener(MouseEvent.MOUSE_MOVE, getMouseOverLine);
      multilineField.addEventListener(MouseEvent.MOUSE_OUT, getMouseOutLine);
      multilineField.text = "Zwraca informacje o wymiarach danego wiersza tekstowego. Parametetry lineIndex:int Numer wiersza, dla którego chcesz uzyskać informacje. Zwraca TextLineMetrics Obiekt TextLineMetrics. Zgłosi błąd RangeError: The line number is out of range.";
      addChild(multilineField);
    }
    private function getMouseOverLine(mouseEvent:MouseEvent):void
    {
      var characterInLine:int = multilineField.getCharIndexAtPoint(10,   mouseEvent.stageY);
      if(characterInLine != -1)
      {
        var lineIndex:int = multilineField.getLineIndexOfChar(characterInLine);
        var firstCharIndex:int = multilineField.getLineOffset(lineIndex);
        var lastCharIndex:int = firstCharIndex + multilineField.getLineLength(lineIndex);
        // chcemy ustawić cały obiekt TextField na kolor czarny,
        // poza tekstem znajdującym się pod kursorem myszy
        multilineField.setTextFormat(blackFormat); 
        multilineField.setTextFormat(redFormat,firstCharIndex, lastCharIndex);
      }
    }
    private function getMouseOutLine(mouseEvent:MouseEvent):void
    {
      multilineField.setTextFormat(blackFormat);
    }
  }
}
