VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "SystemInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Compare Database
Option Explicit

Private Const VER_PLATFORM_WIN32S = 0
Private Const VER_PLATFORM_WIN32_Windows = 1
Private Const VER_PLATFORM_WIN32_NT = 2

Private Const DRIVE_UNKNOWN = 0
Private Const DRIVE_NOT_AVAILABLE = 1
Private Const DRIVE_REMOVABLE = 2
Private Const DRIVE_FIXED = 3
Private Const DRIVE_REMOTE = 4
Private Const DRIVE_CDROM = 5
Private Const DRIVE_RAMDISK = 6

Private Const EWX_LOGOFF = 0
Private Const EWX_SHUTDOWN = 1   'ShutDown Windows
Private Const EWX_REBOOT = 2     'Reboot machine
Private Const EWX_FORCE = 4      'Forces processes to terminate.
Private Const EWX_POWEROFF = 3


Private Type OSVERSIONINFO
  dwVersionInfo As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwplatformID As Long
  szVersion As String * 128
End Type


Private Declare Function GetWindowsDirectory _
  Lib "Kernel32" _
  Alias "GetWindowsDirectoryA" _
 (ByVal lpszReturnBuffer As String, _
  ByVal lpszBuffSize As Long) As Long


Private Declare Function GetSystemDirectory _
  Lib "Kernel32" _
  Alias "GetSystemDirectoryA" _
 (ByVal ReturnBuffer As String, _
  ByVal uiBufferSize As Long) As Long


Private Declare Function GetTempPath _
  Lib "Kernel32" _
  Alias "GetTempPathA" _
  (ByVal BufferSize As Long, _
  ByVal lpszReturnBuffer As String) As Long


Private Declare Function GetCommandLine _
  Lib "Kernel32" _
  Alias "GetCommandLineA" () As String


Private Declare Function GetVersion _
  Lib "Kernel32" _
  Alias "GetVersionExA" _
 (ByRef osVer As OSVERSIONINFO) As Long


Private Declare Function GetUserName _
  Lib "Advapi32" _
  Alias "GetUserNameA" _
 (ByVal Buffer As String, _
  BufferSize As Long) As Long


Private Declare Function GetComputerName _
  Lib "Kernel32" _
  Alias "GetComputerNameA" _
 (ByVal Buffer As String, _
  BufferSize As Long) As Long


Private Declare Function GetDriveType _
  Lib "Kernel32" _
  Alias "GetDriveTypeA" _
 (ByVal lpszPath As String) As Long


Private Declare Function GetDiskFreeSpace _
  Lib "Kernel32" _
  Alias "GetDiskFreeSpaceA" _
 (ByVal lpszPath As String, _
  lpSectors As Long, _
  lpBytes As Long, _
  lpFreeClusters As Long, _
  lpClusters As Long) As Long


Private Declare Function GetVolumeInformation _
  Lib "Kernel32" _
  Alias "GetVolumeInformationA" _
 (ByVal lpszPath As String, _
  ByVal lpVolNameBuffer As String, _
  ByVal lpVolumeNameSize As Long, _
  lpVolSerialNo As Long, _
  lpMaxFileLen As Long, _
  lpSystemFlags As Long, _
  ByVal lpSysNamebuffer As String, _
  ByVal lpSysNameBufSize As Long) As Long


Private Declare Function GetParent _
  Lib "user32" _
 (ByVal hwnd As Long) As Long


Private Declare Function GetWindowText _
  Lib "user32" _
  Alias "GetWindowTextA" _
 (ByVal hwnd As Long, _
  ByVal lpszCaption As String, _
  ByVal CaptionSize As Long) As Long


Private Declare Function GetClassName _
  Lib "user32" _
  Alias "GetClassNameA" _
 (ByVal hwnd As Long, _
  ByVal lpClassName As String, _
  ByVal ClassSize As Long) As Long


Private Declare Function SetWindowText _
  Lib "user32" _
  Alias "SetWindowTextA" _
 (ByVal hwnd As Long, _
  ByVal lpszCaption As String) As Long


Private Declare Function GetDesktopWindow _
  Lib "user32" () As Long
    

Private Declare Function ExitWindowsEx _
  Lib "user32" _
  (ByVal uFlags As Long, _
  ByVal dwReserved As Long) As Long

Public Property Get CommandLine() As String
  CommandLine = GetCommandLine()
End Property


Public Property Get WindowsDirectory() As String
  Dim Buffer As String * 255
  Dim BufferSize As Long
  Dim ReturnValue As Long
  
  BufferSize = Len(Buffer)
  ReturnValue = GetTempPath(BufferSize, Buffer)
  WindowsDirectory = Left(Buffer, ReturnValue)
End Property


Public Property Get SystemDirectory() As String
  Dim ReturnBuffer As String * 255
  Dim BufferSize As Long
  Dim ReturnValue As Long
  
  BufferSize = Len(ReturnBuffer)
  ReturnValue = GetSystemDirectory(ReturnBuffer, BufferSize)
  SystemDirectory = Left(ReturnBuffer, ReturnValue)
End Property


Public Property Get TempDirectory() As String
  Dim Buffer As String * 255
  Dim BufferSize As Long
  Dim ReturnValue As Long
  
  BufferSize = Len(Buffer)
  ReturnValue = GetTempPath(BufferSize, Buffer)
  TempDirectory = Left(Buffer, ReturnValue)
End Property


Public Property Get WindowsVersion() As Long
  Dim RetVal As Long
  Dim VersionNo As OSVERSIONINFO
  Dim Version As String
  
  VersionNo.dwVersionInfo = 148
  RetVal = GetVersion(VersionNo)
  Version = VersionNo.dwMajorVersion & "." & _
      VersionNo.dwMinorVersion
  WindowsVersion = CLng(Version)
End Property


Public Property Get WindowsPlatform()
  Dim RetVal As Long
  Dim VersionNo As OSVERSIONINFO
  Dim Platform As String
  
  VersionNo.dwVersionInfo = 148
  RetVal = GetVersion(VersionNo)
  Select Case VersionNo.dwplatformID
    Case VER_PLATFORM_WIN32S
      WindowsPlatform = "Windows 3.x"
    Case VER_PLATFORM_WIN32_Windows
      WindowsPlatform = "Windows 95"
    Case VER_PLATFORM_WIN32_NT
      WindowsPlatform = "Windows NT"
    Case Else
      WindowsPlatform = "Unknown"
  End Select
End Property


Public Property Get UserName() As String
  Dim UsrName As String * 255
  Dim NameSize As Long
  Dim ReturnValue As Long
  
  NameSize = Len(UsrName)
  ReturnValue = GetUserName(UsrName, NameSize)
  UserName = Left(UsrName, NameSize - 1)
End Property


Public Property Get ComputerName() As String
  Dim CompName As String * 255
  Dim NameSize As Long
  Dim ReturnValue As Long
  
  NameSize = Len(CompName)
  ReturnValue = GetComputerName(CompName, NameSize)
  ComputerName = Left(CompName, NameSize)
End Property


Public Property Get DriveType(PathName As String) As String
  Select Case GetDriveType(PathName)
    Case DRIVE_NOT_AVAILABLE
      DriveType = _
        "DRIVE '" & PathName & "' - NOT AVAILABLE"
    Case DRIVE_REMOVABLE
      DriveType = _
        "DRIVE '" & PathName & "' - REMOVEABLE DRIVE"
    Case DRIVE_FIXED
      DriveType = _
        "DRIVE '" & PathName & "' - FIXED DRIVE"
    Case DRIVE_REMOTE
      DriveType = _
        "DRIVE '" & PathName & "' - NETWORK DRIVE"
    Case DRIVE_CDROM
      DriveType = _
        "DRIVE '" & PathName & "' - CDROM DRIVE"
    Case DRIVE_RAMDISK
      DriveType = _
        "DRIVE '" & PathName & "' - RAM DRIVE"
    Case DRIVE_UNKNOWN
      DriveType = _
        "DRIVE '" & PathName & "' - UNKNOWN"
    Case Else
      DriveType = _
        "DRIVE '" & PathName & "' - UNKNOWN"
  End Select
End Property


Public Property Get DiskFreeSpace(PathName As String) As String
  Dim ReturnValue As Integer
  Dim Sectors As Long
  Dim Bytes As Long
  Dim FreeClusters As Long
  Dim TotalClusters As Long
  
  ReturnValue = GetDiskFreeSpace(PathName, Sectors, _
    Bytes, FreeClusters, TotalClusters)
  DiskFreeSpace = "Free space:  " & _
    Format((Bytes * Sectors) * FreeClusters, "#,##0")
End Property


Public Function VolumeInfo( _
    PathName As String, _
    Selection As Integer) As String

  Dim VolName As String * 255
  Dim BufferSize As Long
  Dim VolSerNo As Long
  Dim MaxFileLen As Long
  Dim SysFlags As Long
  Dim SysName As String * 255
  Dim SysBufSize As Long
  Dim ReturnValue As Long
  
  Const Get_Volume_Name = 1
  Const Get_File_System = 2
  
  BufferSize = Len(VolName)
  SysBufSize = Len(SysName)
  ReturnValue = GetVolumeInformation(PathName, _
    VolName, BufferSize, VolSerNo, MaxFileLen, _
    SysFlags, SysName, SysBufSize)
  If Selection = 1 Then
    VolumeInfo = "Volume Name:  " & Trim(VolName)
  Else
    If Selection = 2 Then
      VolumeInfo = "File System:  " & Trim(SysName)
    End If
  End If
End Function


'Shutdown WINDOWS
Public Function ShutDownWindows() As Long
  ShutDownWindows = ExitWindowsEx(EWX_SHUTDOWN, GetDesktopWindow())
End Function

'Close Current User
Public Function LogOff() As Long
  LogOff = ExitWindowsEx(EWX_LOGOFF, GetDesktopWindow())
End Function

'Reboot Machine
Public Function RebootWindows() As Long
  RebootWindows = ExitWindowsEx(EWX_REBOOT, GetDesktopWindow())
End Function

'Force Log Off
Public Function ForceLogOff() As Long
  ForceLogOff = ExitWindowsEx(EWX_FORCE, GetDesktopWindow())
End Function

'Restart Windows
Public Function RestartWindows() As Long
  Dim i As Integer
  SendKeys "+^%"
  RestartWindows = ExitWindowsEx(EWX_REBOOT, GetDesktopWindow())
  For i = 1 To 2000
      SendKeys "+^%"
      DoEvents
  Next
  SendKeys "+^%"
End Function


