var finalCnumber;

window.onload=function(){
    var csc = document.getElementById("csc");
    if(csc != null) {
        csc.onblur=function(){
            var typ = document.getElementById("cctype");
            if(typ != null){
               if(csc.value.indexOf("Choose") == -1 && ! checkCSC(typ.value,csc.value.
                       replace(/\s/,""))) {
                   eMsg("Prosz poda poprawny kod bezpieczestwa karty.","red");
                   csc.focus();
                   document.getElementById("submit").disabled=true;
               }  else {
                   clearMsg();
                   document.getElementById("submit").disabled=false;

               }
            }
        };
    }
    document.forms[0].onsubmit=function(){
        verify(this.cc.value,this.scode.value,this.cctype.value,
                this.exp_month.value+" "+this.exp_year.value);
        return false;
    };
}

function checkCSC(cardTyp,fldValue){
    var re = null;
    if(cardTyp != null){
        if(cardTyp == "American Express"){
            re = /^\d{4}$/;
            return re.test(fldValue);
            //Mastercard, Visa, Discover
        } else {
             re = /^\d{3}$/;
            return re.test(fldValue);

        }
    }

}
// Numer karty kredytowej, kod bezpieczestwa karty, rodzaj karty kredytowej 
// i data wanoci karty.
function verify(ccard,secure_code,cctype,ccexp){
    if(secure_code.length < 3) {
        eMsg("Prosz poda poprawny kod bezpieczestwa karty.","red");
        return;}
    if(cctype=="Choose one...") {
        eMsg("Prosz poda poprawny rodzaj karty kredytowej.","red");
        return;}
    if (! clientsideVerify(ccard)) {
        eMsg("Prosz poda poprawny numer karty kredytowej.","red");}
    else{
        eMsg("Trwa przetwarzanie karty kredytowej, prosz czeka.","blue");
        ccard=remDashSpace(ccard);
        url="http://www.parkerriver.com/s/verify?cc="+
            encodeURIComponent(ccard)+"&scode="+
            encodeURIComponent(secure_code)+"&type="+
            encodeURIComponent(cctype)+"&exp="+
            encodeURIComponent(ccexp);
        httpRequest("GET",url,true,handleCheck);
    }
}
/* Sprawdzenie, czy wpis dotyczcy karty kredytowej nie jest pusty, 
wystarczajco dugi lub zawiera jakiekolwiek litery. Usunicie z wpisu 
wszystkich mylnikw i spacji, a nastpnie uruchomienie algorytmu Luhn 
na otrzymanym numerze karty. */
function clientsideVerify(ccVal){
    if(ccVal == null || ccVal.length < 13 ||
       ccVal.search(/[a-zA-Z]+/) != -1){ return false; }
    ccVal=remDashSpace(ccVal);
    return (applyLuhn(ccVal) % 10) == 0;

}
function remDashSpace(_number){
    // Usunicie mylnikw lub spacji.
    _number = _number.replace(/-/g,"");
    _number = _number.replace(/ /g,"");
    return _number;
}
//http://en.wikipedia.org/wiki/Luhn_formula
function applyLuhn(cc){
    // Odwrcenie cigu tekstowego.
    var rev = reverse(cc);
    // Pobranie tablicy znakw cigu tekstowego.
    var revArr = rev.split("");
    var total = 0;
    var tmp = 0;
    // Dodanie liczb.
    for(var i = 0; i < revArr.length; i++){
        if((i % 2) > 0){
            tmp = revArr[i]*2;
            tmp= (tmp < 9 ? tmp : (tmp - 9) );
            total += tmp;
        }   else {
            total += Number(revArr[i]);
        }
    }// Koniec ptli for.
    alert(total);
    return total;
}
// Obsuga zdarze dla obiektu XMLHttpRequest.
function handleCheck(){
    var sTag,answer,xmlReturnVal;
    if(request.readyState == 4){
        if(request.status == 200){
            // Implementacja obiektu Document w DOM.
            xmlReturnVal = request.responseXML;
            sTag = xmlReturnVal.getElementsByTagName("cc_status")[0];
            answer= sTag.childNodes[0].data;
            if(answer=="okay"){ eMsg("Informacje dotyczce transakcji zostay "+
               "wysane do sklepu internetowego.","blue");  }
            else { eMsg("Wystpi problem w trakcie przetwarzania karty kredytowej.","red"); }
        } else {
            alert("Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, a programem serwera.");
        }
    }// Koniec zewntrznej ptli if.
}
/* Funkcje narzdziowe:
odwrcenie cigu tekstowego. */
function reverse(str){

    var sArray = str.split("");
    var newS="";
    for(var i = sArray.length-1; i >= 0; i--){
        newS += sArray[i];
    }
    return newS;
}
// Wygenerowanie komunikatu zawierajcego odpowiedni styl.
function eMsg(msg,sColor){
    var div = document.getElementById("message");
    div.style.color=sColor;
    div.style.fontSize="0.9em";
    // Usunicie starych komunikatw.
   clearMsg();
   div.appendChild(document.createTextNode(msg));
}
function clearMsg(){
   document.getElementById("message").innerHTML="";
}