var request;
var symbol;   // Zmienna bdzie przechowywa symbol waloru giedowego.
var numberOfShares;

function getStockPrice(sym,shs){
   if(sym && shs){
      symbol=sym;
      numberOfShares=shs;
      var url="http://localhost:8080/parkerriver/s/stocks?symbol="+sym;
      httpRequest("GET",url,true);
   }
}

// Obsuga zdarze dla obiektu XMLHttpRequest.
function handleResponse(){
   if(request.readyState == 4){
      if(request.status == 200){
         /* Sprawdzenie, czy warto zwrotna rzeczywicie jest liczb. 
         Jeeli tak jest, to nastpuje pomnoenie przez liczb walorw giedowych
         i wywietlenie wyniku. */
         var stockPrice = request.responseText;
         try{
            if(isNaN(stockPrice)) { throw new Error(
               "Zwrcona cena nie jest poprawn liczb.");}
            if(isNaN(numberOfShares)) { throw new Error(
               "Liczba walorw nie jest poprawn liczb.");}
            var info = "Cakowita warto walorw: "+ calcTotal(stockPrice);
            displayMsg(document.getElementById("msgDisplay"),info,"black");
            document.getElementById("stPrice").style.fontSize="0.9em";
            document.getElementById("stPrice").innerHTML ="cena: "+stockPrice;
         } catch (err) {
            displayMsg(document.getElementById("msgDisplay"),
               "Wystpi bd: "+
               err.message,"red");
         }
      } else {
         alert(
            "Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, "+
            "a programem serwera.");
      }
   }// Koniec zewntrznej ptli if.
}

 /* Inicjalizacja obiektu dania, ktry zosta ju skonstruowany. */
function initReq(reqType,url,bool){
   /* Okrelenie funkcji, ktra bdzie obsugiwaa odpowied HTTP. */
   request.onreadystatechange=handleResponse; 
   request.open(reqType,url,bool);
   request.send(null);
}

/* Funkcja opakowujca do skonstruowania obiektu dania.
Parametry:
   reqType: typ dania HTTP, na przykad GET lub POST.
   url: adres URL programu serwerowego.
   asynch: czy danie bdzie wysane asynchronicznie czy te nie. */
function httpRequest(reqType,url,asynch){
    // Przegldarki na bazie Mozilli.
    if(window.XMLHttpRequest){
        request = new XMLHttpRequest();
    } else if (window.ActiveXObject){
        request=new ActiveXObject("Msxml2.XMLHTTP");
        if (! request){
            request=new ActiveXObject("Microsoft.XMLHTTP");
        }
    }
    // Jeeli nie powioda si nawet inicjalizacja ActiveXObject,
    // wwczas danie wci moe by typu null.
    if(request){
       initReq(reqType,url,asynch);
    } else {
       alert("Uywana przegldarka nie pozwala na wykorzystanie "+
         "wszystkich funkcji tej aplikacji!");
    }
}

function calcTotal(price){
   return stripExtraNumbers(numberOfShares * price);
}

/* Usuwamy wszystkie znaki wykraczajce poza zakres czterech znakw po przecinku,
jak ma to miejsce na przykad w 12,3454678. */
function stripExtraNumbers(num) {
    alert(typeof num)
    // Sprawdzenie, czy liczby s poprawne,
    // zakadamy, e caa liczba jest poprawna.
    var numStr =  num.toString(); // Dziaa z liczbami jak z cigami tekstowymi.
    var indx =numStr.indexOf(".");
    if(indx == -1)  { return num; }
    var chArray = numStr.split(".");
    // Drugi element tablicy zawiera wszystkie znaki znajdujce si po przecinku dziesitny,
    if(chArray[1].length <= 4) { return num; }
    // Uywamy metody Number.toPrecision do ograniczenia
    // liczb po przecinku dziesitnych do czterech.
    return num.toPrecision(chArray[0].length + 4);
}

function displayMsg(div,bdyText,txtColor){
   // Sprowadzamy do stanu wyjciowego zawarto DIV.
   div.innerHTML="";
   div.style.backgroundColor="yellow";
   div.style.color=txtColor
   div.innerHTML=bdyText;
}
