var defaultLocationId="USMA0279";
var partId="1012144868";
var licId="67f74aa9fd9cc0e2";
var _host="www.parkerriver.com" //www.parkerriver.com
// Miasto i stan szukanej przez uytkownika lokalizacji.
var _cit = "";
var _stat = "";
window.onload = function(){
    document.getElementById("getWeather").onclick=function(){
        getNewLocation();
    }
    getWeather(defaultLocationId);
}
/* Przykadowy adres URL:

http://www.parkerriver.com/s/weathxml/weatherSearch?
locId=30066&cc=*&dayf=2&prod=xoap&par=1012144868&licId=67f74aa9fd9cc0e2

rzeczywisty:
http://xoap.weather.com/weather/local/30066?cc=*&dayf=2&prod=xoap&par=1012144868&key=67f74aa9fd9cc0e2

wyszukiwanie pooenia:

http://xoap.weather.com/search/search?where=atlanta 

*/

/* Pobranie danych XML prognozy pogody dla danej lokalizacji. */
function getWeather(locationId){
    if (locationId == null || locationId.length=="") { return; }

    var url = "http://"+_host+"/s/weathxml/weatherSearch?&locId="+
              locationId+"&cc=*&dayf=2&prod=xoap&par="+partId+"&key="+licId;
    httpRequest("GET",url,true,handleResponse);
}

function getNewLocation(){
    var val = document.forms[0]._city.value;
    //alert(val);
    if(val.length != 0){
        _cit = val;
    }  else {
        // Do wyszukania niezbdna jest przynajmniej jedna nazwa miasta.
        return;
    }
    var sval = document.forms[0]._state.value;
   // alert(sval);
    if(sval.length != 0){
        _stat = sval;
        getLocation(_cit+","+_stat);
    }   else {
        getLocation(_cit);    // Mona wyszukiwa jedynie nazw miasta.
    }
}
/* Parametrem moe by tylko nazwa miasta lub poczenie miasto,stan, 
jak na przykad Boston,MA. */
function getLocation(_lcity){
    if (_lcity == null || _lcity.length=="") {alert("returning"); return; }
    var url = "http://"+_host+"/s/weathxml/addressSearch?city="+_lcity;
    httpRequest("GET",url,true,handleResponse);

}

// Obsuga zdarze dla obiektu XMLHttpRequest.
function handleResponse(){
    try{
        if(request.readyState == 4){
            if(request.status == 200){
                var _xml = request.responseXML;
                if(_xml != null){
                    var _root = _xml.documentElement;
                    switch(_root.tagName){
                        case "weather":
                            displayWeather(_root); break;
                        case  "search":
                            handleSearchResult(_root); break;
                        case "error" :
                            alert(
                                    "Wyszukiwanie lokalizacji lub pogody spowodowao wygenerowanie bdu. Prosz sprbowa ponownie."); break;
                        default: alert(
                                "W trakcie wyszukiwania zosta wygenerowany nieokrelony problem. Prosz sprbowa ponownie.");
                    }
                } else {
                    alert("Serwer zwrci pust warto dla XML. Prosz sporbowa ponownie w cigu kilku sekund.");
                }

            } else {
                // Warto waciwoci request.status wynosi 503, 
                // jeeli aplikacja jest niedostpna, oraz 
                // warto 500, jeli aplikacja zawiera bd.
                alert(
                    "Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, "+
                    "a programem serwera.");
            }
        }// Koniec zewntrznej ptli if.
    } catch (err) {
      alert("Serwer nie jest dostpny "+
         "dla tej aplikacji. Prosz wkrtce sprbowa"+
         " ponownie. \nBd: "+err.message);

    }
}
/* Wywietlenie prognozy pogody na podstawie danych XML 
pochodzcych z API Weather.com. */
function displayWeather(rootElement){
    if(rootElement != null){
        var loc= rootElement.getElementsByTagName("loc")[0];
        setupToplevel(loc);
        var  dayf = rootElement.getElementsByTagName("dayf")[0];
        setupWeather(dayf);
    }
}

function handleSearchResult(rootEl){
    // Wywoanie getWeather(locationId)
    var locArray = rootEl.getElementsByTagName("loc");
    var elVal = null;
    for(var i = 0; i < locArray.length; i++){
        elVal = locArray[i].firstChild.nodeValue;
        // Jeeli w danych do wyszukania zosta podany stan,
        // wtedy naley go tutaj uwzgldni.
        if(_stat.length != 0){
            if (elVal == _cit+", "+_stat.toUpperCase()) { getWeather(locArray[i].getAttribute("id")); }
        }  else {
            alert("Nazwa stanu nie zostaa podana.");
            // Jeeli nazwa stanu nie zostaa podana, to wtedy naley po prostu zwrci pierwszy wynik.
            getWeather(locArray[i].getAttribute("id"));
            break;
        }
    }

}

function setupToplevel(_element){
    if(_element != null){
        setupElement( _element.getElementsByTagName("dnam")[0],document.getElementById("city_state"),"Location");
        setupElement( _element.getElementsByTagName("tm")[0],document.getElementById("time"),"Time");
        setupElement( _element.getElementsByTagName("lat")[0],document.getElementById("lat"),"Lat");
        setupElement( _element.getElementsByTagName("lon")[0],document.getElementById("lng"),"Long");
        setupElement( _element.getElementsByTagName("sunr")[0],document.getElementById("sunrise"),"Sunrise");
        setupElement( _element.getElementsByTagName("suns")[0],document.getElementById("sunset"),"Sunset");
    }
}

function setupElement(_node,_span,txtMsg)  {
    if(arguments.length == 3){
        _span.innerHTML= txtMsg+": "+_node.firstChild.nodeValue;
    } else {
        _span.innerHTML= _node.firstChild.nodeValue;
    }
}

function setupImgElement(_node,_imgElement)  {
    _imgElement.src="http://"+_host+"/ajaxhacks/img/"+_node.firstChild.nodeValue+".png";
}

function setupWeather(_element){
    if(_element != null){
        var parts =  _element.getElementsByTagName("part");  /* Zawiera podelementy opisujce prognoz pogody dzie/noc. */
        var dpart = null;
        setupElement( _element.getElementsByTagName("lsup")[0],document.getElementById("date"));
        setupElement( _element.getElementsByTagName("hi")[0],document.getElementById("high"),"high temp");
        setupElement( _element.getElementsByTagName("low")[0],document.getElementById("low"),"low temp");
        for(var i = 0; i < parts.length; i++)   {
            if(parts[i].getAttribute("p") == "d") { dpart=parts[i];}
        }
        setupImgElement( dpart.getElementsByTagName("icon")[0],document.getElementById("w_icon"));
        setupElement(dpart.getElementsByTagName("ppcp")[0],document.getElementById("precip"),"precipitation (% chance)");
        setupElement( dpart.getElementsByTagName("hmid")[0],document.getElementById("humid"),"humidity (%)");
        setupElement(dpart.getElementsByTagName("t")[0],document.getElementById("desc"));
        var _wind = dpart.getElementsByTagName("wind")[0];
        setupElement( _wind.getElementsByTagName("s")[0],document.getElementById("spd_wind"),"wind speed");
        setupElement( _wind.getElementsByTagName("t")[0],document.getElementById("dir_wind"),"wind direction");
    }

}
