var map = null;
window.onload=function(){
    createMap();
    document.getElementById("submit").onclick=function(){
        getDirections(document.forms[0]._street.value,
                document.forms[0]._city.value,
                document.forms[0]._state.value,
                document.forms[0]._dname.value,
                document.forms[0]._latitude.value,
                document.forms[0]._longitude.value);
    };
    document.getElementById("rem_bubbles").onclick=function(){
        clearOverlays();
    };

    document.getElementById("yah_maps").onclick=function(){
        createYMap();
    };
};
function createYMap(){
    writeMap(document.forms[0]._latitude.value,
            document.forms[0]._longitude.value);
}
function createMap(){
    map = new GMap(document.getElementById("map"));
    GEvent.addListener(map, 'click', function(overlay, point) {
        document.forms[0]._longitude.value=point.x;
        document.forms[0]._latitude.value=point.y;
        map.addOverlay(new GMarker(point));

    });
    map.addControl(new GLargeMapControl());
    map.addControl(new GMapTypeControl());
    // Wyrodkowanie mniej wicej na centralnej czci USA.
    map.centerAndZoom(new GPoint(-97.20703, 40.580584), 14);
}

function clearOverlays(){
    if(map != null){
        map.clearOverlays();
    }
}

function getDirections(street,city,state,
                       destName,lat,lng){

    var _str = encodeURIComponent(street);
    var _cit = encodeURIComponent(city);
    var url = "http://www.parkerriver.com/s/dd?"+_str+"&tlt="+
              lat+"&tln="+lng+"&csz="+
              _cit+"%2C"+state+"&country=us&tname="+destName;
    httpRequest("GET",url,true,handleResponse);
}

// Obsuga zdarze dla obiektu XMLHttpRequest
function handleResponse(){
    try{
        if(request.readyState == 4){
            if(request.status == 200){
                var _dirs = request.responseText;
                var targDiv = document.getElementById("ymap_container");
                targDiv.innerHTML=_dirs+
                                  '<p><form><button type=\"button\" onclick=\"window.print()\">Wywietl informacje</button></form></p>';
            } else {
                // Jeeli apliakcja nie jest dostpna, wtedy stan dania wynosi 503, natomiast w przypadku bdu w aplikacji stan dania wynosi 500.
                alert("Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, a programem serwera.");
            }
        }// Koniec zewntrznej ptli if.
    } catch (err)   {
        alert("Serwer nie jest dostpny dla tej aplikacji. Prosz wkrtce sprbowa ponownie. \nBd: "+err.message);

    }
}

function writeMap(lat,lng){
    //document.getElementById('ymap_container').style.visibility="visible";
    var _point = new YGeoPoint(parseInt(lat), parseInt(lng));
    var _map = new  YMap(document.getElementById('ymap_container'));
    _map.drawZoomAndCenter(_point, 8);
    _map.addPanControl();
    _map.addZoomLong();
    document.getElementById('yah_maps').disabled=true;
}
