var sportTyp = "";
var checksArray = null;
var request=null;
window.onload=function(){
   // Rozwijane menu 'expanding checkboxes'. 
   var sel = document.getElementById("expand");
   // Doczenie do funkcji obsugi zdarze onclick.
   if(sel != null){
      sel.onclick=function(){
         getMoreChoices(this)};
   }
   // Rozwijane menu 'restoring checkboxes'.
   var selr = document.getElementById("restore");
   // Doczenie do funkcji obsugi zdarze onclick.
   if(selr != null){
      selr.onclick=function(){
         restore(this)};
   }
   // Umieszczenie wszystkich istniejcych elementw pl wyboru w dwch tablicach,
   // w celu moliwoci przywrcenia oryginalnych list pl wyboru.
   checksArray = new Object();
   checksArray.team = new Array();
   checksArray.individual = new Array();
   var ckArr = document.getElementsByTagName("input");
   populateArray(ckArr,"team");
   populateArray(ckArr,"individual");
}

function populateArray(arr,typ)  {
    var inc = 0;
    for(var i = 0; i < arr.length; i++){
        if(arr[i].type == "checkbox") {
            if(arr[i].name.indexOf(typ) != -1) {
                checksArray[typ][inc] = arr[i];
                inc++;
            }
        }
    }
}
// Zwrot liczby elementw input checkbox zawartych
// w elemencie div.
function getCheckboxesLength(_sportTyp){
   var div = document.getElementById(_sportTyp+"_d");
   var len=0;
   for(var i =0; i < div.childNodes.length; i++){
      if(div.childNodes[i].nodeName == "INPUT" ||
         div.childNodes[i].nodeName == "input" ){
         len++;
      }
   }
   return len;
}

function getMoreChoices(obj){
    if (obj == null ) { return; }
    var url = "";
    var optsArray = obj.options;
    var val = "";
    for(var i=0; i < optsArray.length; i++){
        if(optsArray[i].selected) {
            val=optsArray[i].value;  break;
        }
    }
    sportTyp=val;
    // Okrelenie, czy pola wyboru zostay ju rozbudowane.
    if(checksArray[sportTyp].length < getCheckboxesLength(sportTyp))  {
        return;
    }
    url = "http://www.parkerriver.com/s/expand?expType="+val;
    httpRequest("GET",url,true);
}

function addToChecks(obj){
    // Element div zawierajcy pola wyboru.
    var div = document.getElementById(sportTyp+"_d");
    var el = null;
    // Dodanie nowych pl wyboru, ktre zostay pobrane z serwera.
    for(var h = 0; h < obj.length; h++){
        el = document.createElement("input");
        el.type="checkbox";
        el.name=sportTyp+"_sports";
        el.value=obj[h];
        div.appendChild(el);
        div.appendChild(document.createTextNode(obj[h]));
        div.appendChild(document.createElement("br"));
    }
}

function restore(_sel) {
    var val;
    var opts =  _sel.options;
    for (var i = 0; i < opts.length; i++){
        if(opts[i].selected) { val=opts[i].value; break;}
    }
    // Przywracamy jedynie wtedy, gdy pola wyboru
    // zostay ju rozbudowane.
    if(checksArray[sportTyp].length < getCheckboxesLength(sportTyp)) {
        var _div = document.getElementById(val+"_d");
        if(_div != null)  {
            // Ponowne utworzenie listy oryginalnych pl wyboru.
            _div.innerHTML="";
            var tmpArr = checksArray[val];
            for(var j = 0; j < tmpArr.length; j++){
                _div.appendChild(tmpArr[j]);
                _div.appendChild(document.createTextNode(tmpArr[j].value));
                _div.appendChild(document.createElement("br"));
            }
        }
    }
}
// Funkcja dla obsugi zdarze obiektu XMLHttpRequest.
function handleResponse(){
    try{
        if(request.readyState == 4){
            if(request.status == 200){
                var resp =  request.responseText;
                if(resp != null){
                    // Warto zwrotna jest obiektem JSON.
                    addToChecks(eval(resp));
                }
            } else {
                // Jeeli apliakcja nie jest dostpna, wtedy stan dania wynosi 503,
                // natomiast w przypadku bdu w aplikacji stan dania wynosi 500.
                alert("Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, a programem serwera.");
            }
        }// Koniec zewntrznej ptli if.
    } catch (err)   {
        alert("Serwer nie jest dostpny dla tej aplikacji. Prosz wkrtce sprbowa ponownie. \nBd: "+err.message);
    }
}

/* Inicjalizacja obiektu dania, ktry zosta ju skonstruowany. */
function initReq(reqType,url,bool){
    try{
        /* Okrelenie funkcji, ktra bdzie obsugiwaa odpowied HTTP. */
        request.onreadystatechange=handleResponse;
        request.open(reqType,url,bool);
        request.send(null);
    } catch (errv) {

        alert(
                "Aplikacja nie moe w tej chwili nawiza poczenia z serwerem."+
                " Prosz wkrtce sprbowa ponownie.");
}

/* Funkcja opakowujca do skonstruowania obiektu dania.
Parametry:
   reqType: typ dania HTTP, na przykad GET lub POST.
   url: adres URL programu serwerowego.
   asynch: czy danie bdzie wysane asynchronicznie, czy te nie. */
function httpRequest(reqType,url,asynch){
   // Przegldarki na bazie Mozilli.
   if(window.XMLHttpRequest){
      request = new XMLHttpRequest();
   } else if (window.ActiveXObject){
      request=new ActiveXObject("Msxml2.XMLHTTP");
      if (! request){
         request=new ActiveXObject("Microsoft.XMLHTTP");
      }
   }
   // Jeeli nie powioda si nawet inicjalizacja ActiveXObject,
   // wwczas danie wci moe by typu null.
   if(request){
      initReq(reqType,url,asynch);
   } else {
      alert(
         "Uywana przegldarka nie pozwala na wykorzystanie "+
         "wszystkich funkcji tej aplikacji!");
   }
}
