var map = null;
window.onload=function(){
    createMap();
    document.getElementById("submit").onclick=function(){
        getDirections(document.forms[0]._street.value,
                document.forms[0]._city.value,
                document.forms[0]._state.value,
                document.forms[0]._dname.value,
                document.forms[0]._latitude.value,
                document.forms[0]._longitude.value);
    };
     document.getElementById("rem_bubbles").onclick=function(){
         clearOverlays();
     };
};
function createMap(){
    map = new GMap(document.getElementById("map"));
    GEvent.addListener(map, 'click', function(overlay, point) {
        document.forms[0]._longitude.value=point.x;
        document.forms[0]._latitude.value=point.y;
        map.addOverlay(new GMarker(point));

    });
    map.addControl(new GLargeMapControl());
    map.addControl(new GMapTypeControl());
    // Centrowanie mniej wicej na rodku USA.
    map.centerAndZoom(new GPoint(-97.20703, 40.580584), 14);
}

function clearOverlays(){
    if(map != null){
        map.clearOverlays();
    }
}

function getDirections(street,city,state,
                       destName,lat,lng){

    var _str = encodeURIComponent(street);
    var _cit = encodeURIComponent(city);
    var url = "http://www.parkerriver.com/s/dd?"+_str+"&tlt="+
              lat+"&tln="+lng+"&csz="+
              _cit+"%2C"+state+"&country=us&tname="+destName;
    httpRequest("GET",url,true);
}

// Obsuga zdarze dla obiektu XMLHttpRequest
function handleResponse(){
    try{
        if(request.readyState == 4){
            if(request.status == 200){
                var _dirs = request.responseText;
                var targDoc = parent.frames[1].document;
                targDoc.open();
                targDoc.write('<html><head><title></title></head><body>'+
                              _dirs+'<p><form><button type=\"button\" onclick=\"window.print()\">Wywietl informacje</button></form></p></body></html>');
                targDoc.close();
                // Nie dziaa:  var div = targdoc.getElementById("dirs");
            } else {
                // Jeeli apliakcja nie jest dostpna, wtedy stan dania wynosi 503, natomiast w przypadku bdu w aplikacji stan dania wynosi 500.
                alert("Wystpi problem z komunikacj midzy obiektem XMLHttpRequest, a programem serwera.");
            }
        }// Koniec zewntrznej ptli if.
    } catch (err)   {
        alert("Serwer nie jest dostpny dla tej aplikacji. Prosz wkrtce sprbowa ponownie. \nBd: "+err.message);

    }
}

/* Inicjalizacja obiektu dania, ktry zosta ju skonstruowany. */
function initReq(reqType,url,bool){
    try{
        /* Okrelenie funkcji, ktra bdzie obsugiwaa odpowied HTTP. */
        request.onreadystatechange=handleResponse;
        request.open(reqType,url,bool);
        request.send(null);
    } catch (errv) {

        alert(
                "Aplikacja nie moe w tej chwili nawiza poczenia z serwerem."+
                " Prosz wkrtce sprbowa ponownie.");
}

/* Funkcja opakowujca do skonstruowania obiektu dania.
Parametry:
   reqType: typ dania HTTP, na przykad GET lub POST.
   url: adres URL programu serwerowego.
   asynch: czy danie bdzie wysane asynchronicznie, czy te nie. */
function httpRequest(reqType,url,asynch){
   // Przegldarki na bazie Mozilli.
   if(window.XMLHttpRequest){
      request = new XMLHttpRequest();
   } else if (window.ActiveXObject){
      request=new ActiveXObject("Msxml2.XMLHTTP");
      if (! request){
         request=new ActiveXObject("Microsoft.XMLHTTP");
      }
   }
   // Jeeli nie powioda si nawet inicjalizacja ActiveXObject,
   // wwczas danie wci moe by typu null.
   if(request){
      initReq(reqType,url,asynch);
   } else {
      alert(
         "Uywana przegldarka nie pozwala na wykorzystanie "+
         "wszystkich funkcji tej aplikacji!");
   }
}
