/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.MultiJoin;

public class ProjectMultiJoinMergeRule
extends RelOptRule {
    public static final ProjectMultiJoinMergeRule INSTANCE = new ProjectMultiJoinMergeRule();

    private ProjectMultiJoinMergeRule() {
        super(ProjectMultiJoinMergeRule.operand(LogicalProject.class, ProjectMultiJoinMergeRule.operand(MultiJoin.class, ProjectMultiJoinMergeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        MultiJoin multiJoin = (MultiJoin)call.rel(1);
        boolean allSet = true;
        for (int i = 0; i < multiJoin.getInputs().size(); ++i) {
            if (multiJoin.getProjFields().get(i) != null) continue;
            allSet = false;
            break;
        }
        if (allSet) {
            return;
        }
        MultiJoin newMultiJoin = RelOptUtil.projectMultiJoin(multiJoin, project);
        LogicalProject newProject = (LogicalProject)RelOptUtil.createProject((RelNode)newMultiJoin, project.getProjects(), project.getRowType().getFieldNames());
        call.transformTo(newProject);
    }
}

