/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;

public class ReflectiveRelMetadataProvider
implements RelMetadataProvider,
ReflectiveVisitor {
    private final Map<Class<RelNode>, Function<RelNode, Metadata>> map;
    private final Class<?> metadataClass0;

    protected ReflectiveRelMetadataProvider(Map<Class<RelNode>, Function<RelNode, Metadata>> map, Class<?> metadataClass0) {
        assert (!map.isEmpty()) : "are your methods named wrong?";
        this.map = map;
        this.metadataClass0 = metadataClass0;
    }

    public static RelMetadataProvider reflectiveSource(Method method, Object target) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, (ImmutableList<Method>)ImmutableList.of((Object)method));
    }

    public static RelMetadataProvider reflectiveSource(Object target, Method ... methods) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, (ImmutableList<Method>)ImmutableList.copyOf((Object[])methods));
    }

    private static RelMetadataProvider reflectiveSource(final Object target, final ImmutableList<Method> methods) {
        assert (methods.size() > 0);
        Method method0 = (Method)methods.get(0);
        final Class<?> metadataClass0 = method0.getDeclaringClass();
        assert (Metadata.class.isAssignableFrom(metadataClass0));
        for (Method method : methods) {
            assert (method.getDeclaringClass() == metadataClass0);
        }
        HashSet classes = Sets.newHashSet();
        HashMap handlerMap = Maps.newHashMap();
        for (Method handlerMethod : target.getClass().getMethods()) {
            for (Method method : methods) {
                if (!ReflectiveRelMetadataProvider.couldImplement(handlerMethod, method)) continue;
                Class<?> relNodeClass = handlerMethod.getParameterTypes()[0];
                classes.add(relNodeClass);
                handlerMap.put(Pair.of(relNodeClass, method), handlerMethod);
            }
        }
        HashMap methodsMap = Maps.newHashMap();
        for (Class key : classes) {
            ImmutableNullableList.Builder<Method> builder = ImmutableNullableList.builder();
            for (Method method : methods) {
                builder.add(ReflectiveRelMetadataProvider.find(handlerMap, key, method));
            }
            final List handlerMethods = builder.build();
            Function<RelNode, Metadata> function = new Function<RelNode, Metadata>(){

                public Metadata apply(final RelNode rel) {
                    return (Metadata)Proxy.newProxyInstance(metadataClass0.getClassLoader(), new Class[]{metadataClass0}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object[] args1;
                            if (method.equals(BuiltInMethod.METADATA_REL.method)) {
                                return rel;
                            }
                            if (method.equals(BuiltInMethod.OBJECT_TO_STRING.method)) {
                                return metadataClass0.getSimpleName() + "(" + rel + ")";
                            }
                            int i = methods.indexOf((Object)method);
                            if (i < 0) {
                                throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                            }
                            if (args == null) {
                                args1 = new Object[]{rel};
                            } else {
                                args1 = new Object[args.length + 1];
                                args1[0] = rel;
                                System.arraycopy(args, 0, args1, 1, args.length);
                            }
                            Method handlerMethod = (Method)handlerMethods.get(i);
                            if (handlerMethod == null) {
                                throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                            }
                            return handlerMethod.invoke(target, args1);
                        }
                    });
                }
            };
            methodsMap.put(key, function);
        }
        return new ReflectiveRelMetadataProvider(methodsMap, metadataClass0);
    }

    private static Method find(Map<Pair<Class<RelNode>, Method>, Method> handlerMap, Class<RelNode> relNodeClass, Method method) {
        ArrayList newSources = Lists.newArrayList();
        while (relNodeClass != null) {
            Method implementingMethod = handlerMap.get(Pair.of(relNodeClass, method));
            if (implementingMethod != null) {
                return implementingMethod;
            }
            newSources.add(relNodeClass);
            for (Class<?> clazz : relNodeClass.getInterfaces()) {
                if (!RelNode.class.isAssignableFrom(clazz) || (implementingMethod = handlerMap.get(Pair.of(clazz, method))) == null) continue;
                return implementingMethod;
            }
            if (RelNode.class.isAssignableFrom(relNodeClass.getSuperclass())) {
                relNodeClass = relNodeClass.getSuperclass();
                continue;
            }
            relNodeClass = null;
        }
        return null;
    }

    private static boolean couldImplement(Method handlerMethod, Method method) {
        Class<?>[] parameterTypes;
        if (!handlerMethod.getName().equals(method.getName()) || (handlerMethod.getModifiers() & 8) != 0 || (handlerMethod.getModifiers() & 1) == 0) {
            return false;
        }
        Class<?>[] parameterTypes1 = handlerMethod.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes = method.getParameterTypes()).length + 1 || !RelNode.class.isAssignableFrom(parameterTypes1[0])) {
            return false;
        }
        return Util.skip(Arrays.asList(parameterTypes1)).equals(Arrays.asList(parameterTypes));
    }

    @Override
    public Function<RelNode, Metadata> apply(Class<? extends RelNode> relClass, Class<? extends Metadata> metadataClass) {
        if (metadataClass == this.metadataClass0) {
            ArrayList newSources = Lists.newArrayList();
            while (relClass != null) {
                Function<RelNode, Metadata> function = this.map.get(relClass);
                if (function != null) {
                    for (Class clazz : newSources) {
                        this.map.put(clazz, function);
                    }
                    return function;
                }
                newSources.add(relClass);
                for (Class<?> interfaceClass : relClass.getInterfaces()) {
                    if (!RelNode.class.isAssignableFrom(interfaceClass) || (function = this.map.get(interfaceClass)) == null) continue;
                    for (Class clazz : newSources) {
                        this.map.put(clazz, function);
                    }
                    return function;
                }
                if (RelNode.class.isAssignableFrom(relClass.getSuperclass())) {
                    relClass = relClass.getSuperclass();
                    continue;
                }
                relClass = null;
            }
        }
        return null;
    }
}

