/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

public class RealFFTUtils_2D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private final int columns;
    private final int rows;

    public RealFFTUtils_2D(int rows, int columns) {
        this.columns = columns;
        this.rows = rows;
    }

    public int getIndex(int r, int c) {
        int cmod2 = c & 1;
        int rmul2 = r << 1;
        if (r != 0) {
            if (c <= 1) {
                if (rmul2 == this.rows) {
                    if (cmod2 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return this.rows * this.columns >> 1;
                }
                if (rmul2 < this.rows) {
                    return this.columns * r + cmod2;
                }
                if (cmod2 == 0) {
                    return this.columns * (this.rows - r);
                }
                return -(this.columns * (this.rows - r) + 1);
            }
            if (c == this.columns || c == this.columns + 1) {
                if (rmul2 == this.rows) {
                    if (cmod2 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return (this.rows * this.columns >> 1) + 1;
                }
                if (rmul2 < this.rows) {
                    if (cmod2 == 0) {
                        return this.columns * (this.rows - r) + 1;
                    }
                    return -(this.columns * (this.rows - r));
                }
                return this.columns * r + 1 - cmod2;
            }
            if (c < this.columns) {
                return this.columns * r + c;
            }
            if (cmod2 == 0) {
                return this.columns * (this.rows + 2 - r) - c;
            }
            return -(this.columns * (this.rows + 2 - r) - c + 2);
        }
        if (c == 1 || c == this.columns + 1) {
            return Integer.MIN_VALUE;
        }
        if (c == this.columns) {
            return 1;
        }
        if (c < this.columns) {
            return c;
        }
        if (cmod2 == 0) {
            return (this.columns << 1) - c;
        }
        return -((this.columns << 1) - c + 2);
    }

    public void pack(double val, int r, int c, double[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[pos + index] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[pos - index] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(double val, int r, int c, double[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[index / this.columns][index % this.columns] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[-index / this.columns][-index % this.columns] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(float val, int r, int c, float[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[pos + index] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[pos - index] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(float val, int r, int c, float[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[index / this.columns][index % this.columns] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[-index / this.columns][-index % this.columns] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public double unpack(int r, int c, double[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[pos + index];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[pos - index];
        }
        return 0.0;
    }

    public double unpack(int r, int c, double[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[index / this.columns][index % this.columns];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[-index / this.columns][-index % this.columns];
        }
        return 0.0;
    }

    public float unpack(int r, int c, float[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[pos + index];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[pos - index];
        }
        return 0.0f;
    }

    public float unpack(int r, int c, float[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[index / this.columns][index % this.columns];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[-index / this.columns][-index % this.columns];
        }
        return 0.0f;
    }
}

